sub _MACHINE { &sparc;}
sub MACHINE {"sparc";}
sub _MACHINE_ARCH { &sparc;}
sub MACHINE_ARCH {"sparc";}
sub MID_MACHINE { &MID_SPARC;}
if (defined &_KERNEL) {
    if (!defined &_LOCORE) {
	require 'machine/cpu.ph';
    }
}
sub ALIGNBYTES {7;}
sub ALIGN {
    local($p) = @_;
    eval "((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES)";
}
sub SUN4_PGSHIFT {13;}
sub SUN4CM_PGSHIFT {12;}
if (defined( &SUN4) && !defined( &SUN4C) && !defined( &SUN4M)) {
    eval 'sub NBPG {8192;}';
    eval 'sub PGOFSET {( &NBPG-1);}';
    eval 'sub PGSHIFT { &SUN4_PGSHIFT;}';
}
if (!defined( &SUN4) && (defined( &SUN4C) || defined( &SUN4M))) {
    eval 'sub NBPG {4096;}';
    eval 'sub PGOFSET {( &NBPG-1);}';
    eval 'sub PGSHIFT { &SUN4CM_PGSHIFT;}';
}
if (defined( &SUN4) && (defined( &SUN4C) || defined( &SUN4M))) {
    if (defined( &_KERNEL) && !defined( &_LOCORE)) {
    }
    eval 'sub NBPG { &nbpg;}';
    eval 'sub PGOFSET { &pgofset;}';
    eval 'sub PGSHIFT { &pgshift;}';
}
sub KERNBASE {0xf8000000;}
sub KERNTEXTOFF {0xf8004000;}
sub DEV_BSIZE {512;}
sub DEV_BSHIFT {9;}
sub BLKDEV_IOSIZE {2048;}
sub MAXPHYS {(64 * 1024);}
sub CLSIZE {1;}
sub CLSIZELOG2 {0;}
sub SSIZE {1;}
sub USPACE {8192;}
sub MSIZE {128;}
sub MCLBYTES {2048;}
sub MCLSHIFT {11;}
sub MCLOFSET {( &MCLBYTES - 1);}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS {512;}';
    }
    else {
	eval 'sub NMBCLUSTERS {256;}';
    }
}
if (!defined &NKMEMCLUSTERS) {
    eval 'sub NKMEMCLUSTERS {(6 * 1024 * 1024 /  &CLBYTES);}';
}
sub ctod {
    local($x) = @_;
    eval "(($x) << ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub dtoc {
    local($x) = @_;
    eval "(($x) >> ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub ctob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
sub btoc {
    local($x) = @_;
    eval "((($x) +  &PGOFSET) >>  &PGSHIFT)";
}
sub btodb {
    local($x) = @_;
    eval "(($x) >>  &DEV_BSHIFT)";
}
sub dbtob {
    local($x) = @_;
    eval "(($x) <<  &DEV_BSHIFT)";
}
sub bdbtofsb {
    local($bn) = @_;
    eval "(($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE))";
}
if (defined &_KERNEL) {
    if (!defined &_LOCORE) {
	eval 'sub rctov {
	    local($n) = @_;
	    eval "( &ctob((($n)-1))+ &dvma_base)";
	}';
	eval 'sub vtorc {
	    local($v) = @_;
	    eval "(( &btoc(($v)- &dvma_base))+1)";
	}';
	eval 'sub DELAY {
	    local($n) = @_;
	    eval " &delay($n)";
	}';
    }
}
sub CPU_SUN4 {0;}
sub CPU_SUN4C {1;}
sub CPU_SUN4M {2;}
sub SUN4_100 {0x22;}
sub SUN4_200 {0x21;}
sub SUN4_300 {0x23;}
sub SUN4_400 {0x24;}
sub SUN4M_MS {0x04;}
sub SUN4M_SS {0x40;}
sub SUN4M_HS {0x10;}
sub SUN4M_RT620 {0x1f;}
sub SUN4M_STP1020N {0x41;}
sub SUN4M_STP1020P {0x40;}
sub SUN4M_STP1020A {0x40;}
sub SUN4M_MMU_HS {0x1;}
sub SUN4M_MMU_SS {0x0;}
sub SUN4M_MMU_MS1 {0x4;}
sub SUN4M_MMU_MS {0x0;}
if (defined( &SUN4M) && defined( &SUN4C) && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {( &cputyp ==  &CPU_SUN4M);}';
    eval 'sub CPU_ISSUN4C {( &cputyp ==  &CPU_SUN4C);}';
    eval 'sub CPU_ISSUN4 {( &cputyp ==  &CPU_SUN4);}';
    eval 'sub CPU_ISSUN4OR4C {( &cputyp ==  &CPU_SUN4 ||  &cputyp ==  &CPU_SUN4C);}';
    eval 'sub CPU_ISSUN4COR4M {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}';
}
elsif (defined( &SUN4M) && defined( &SUN4C) && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {( &cputyp ==  &CPU_SUN4M);}';
    eval 'sub CPU_ISSUN4C {( &cputyp ==  &CPU_SUN4C);}';
    eval 'sub CPU_ISSUN4 {(0);}';
    eval 'sub CPU_ISSUN4OR4C {( &cputyp ==  &CPU_SUN4C);}';
    eval 'sub CPU_ISSUN4COR4M {( &cputyp ==  &CPU_SUN4C ||  &cputyp ==  &CPU_SUN4M);}';
}
elsif (defined( &SUN4M) && !defined( &SUN4C) && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {( &cputyp ==  &CPU_SUN4M);}';
    eval 'sub CPU_ISSUN4C {(0);}';
    eval 'sub CPU_ISSUN4 {( &cputyp ==  &CPU_SUN4);}';
    eval 'sub CPU_ISSUN4OR4C {( &cputyp ==  &CPU_SUN4);}';
    eval 'sub CPU_ISSUN4COR4M {( &cputyp ==  &CPU_SUN4M);}';
}
elsif (defined( &SUN4M) && !defined( &SUN4C) && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {(1);}';
    eval 'sub CPU_ISSUN4C {(0);}';
    eval 'sub CPU_ISSUN4 {(0);}';
    eval 'sub CPU_ISSUN4OR4C {(0);}';
    eval 'sub CPU_ISSUN4COR4M {(1);}';
}
elsif (!defined( &SUN4M) && defined( &SUN4C) && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {(0);}';
    eval 'sub CPU_ISSUN4C {( &cputyp ==  &CPU_SUN4C);}';
    eval 'sub CPU_ISSUN4 {( &cputyp ==  &CPU_SUN4);}';
    eval 'sub CPU_ISSUN4OR4C {(1);}';
    eval 'sub CPU_ISSUN4COR4M {( &cputyp ==  &CPU_SUN4C);}';
}
elsif (!defined( &SUN4M) && defined( &SUN4C) && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {(0);}';
    eval 'sub CPU_ISSUN4C {(1);}';
    eval 'sub CPU_ISSUN4 {(0);}';
    eval 'sub CPU_ISSUN4OR4C {(1);}';
    eval 'sub CPU_ISSUN4COR4M {(1);}';
}
elsif (!defined( &SUN4M) && !defined( &SUN4C) && defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {(0);}';
    eval 'sub CPU_ISSUN4C {(0);}';
    eval 'sub CPU_ISSUN4 {(1);}';
    eval 'sub CPU_ISSUN4OR4C {(1);}';
    eval 'sub CPU_ISSUN4COR4M {(0);}';
}
elsif (!defined( &SUN4M) && !defined( &SUN4C) && !defined( &SUN4)) {
    eval 'sub CPU_ISSUN4M {(0);}';
    eval 'sub CPU_ISSUN4C {(0);}';
    eval 'sub CPU_ISSUN4 {(0);}';
    eval 'sub CPU_ISSUN4OR4C {(0);}';
    eval 'sub CPU_ISSUN4COR4M {(0);}';
}
1;
