sub MVMEPROM_INCHR {0x00;}
sub MVMEPROM_INSTAT {0x01;}
sub MVMEPROM_INLN {0x02;}
sub MVMEPROM_READSTR {0x03;}
sub MVMEPROM_READLN {0x04;}
sub MVMEPROM_OUTCHR {0x20;}
sub MVMEPROM_OUTSTR {0x21;}
sub MVMEPROM_DSKRD {0x10;}
sub MVMEPROM_DSKWR {0x11;}
sub MVMEPROM_DSKCFIG {0x12;}
sub MVMEPROM_DSKFMT {0x14;}
sub MVMEPROM_DSKCTRL {0x15;}
sub MVMEPROM_NETCTRL {0x1d;}
sub MVMEPROM_OUTSTRCRLF {0x22;}
sub MVMEPROM_WRITE {0x23;}
sub MVMEPROM_WRITELN {0x24;}
sub MVMEPROM_DELAY {0x43;}
sub MVMEPROM_RTC_RD {0x53;}
sub MVMEPROM_EXIT {0x63;}
sub MVMEPROM_GETBRDID {0x70;}
sub MVMEPROM_ENVIRON {0x71;}
sub NETCTRLCMD_GETETHER {1;}
sub ENVIRONCMD_WRITE {1;}
sub ENVIRONCMD_READ {2;}
sub ENVIRONTYPE_EOL {0;}
sub ENVIRONTYPE_START {1;}
sub ENVIRONTYPE_DISKBOOT {2;}
sub ENVIRONTYPE_ROMBOOT {3;}
sub ENVIRONTYPE_NETBOOT {4;}
sub ENVIRONTYPE_MEMSIZE {5;}
if (!defined &_LOCORE) {
    eval 'sub BUG_FILE_MARK {0x80;}';
    eval 'sub IGNORE_FILENUM {0x02;}';
    eval 'sub END_OF_FILE {0x01;}';
    eval 'sub MVMEPROM_BLOCK_SIZE {256;}';
}
sub MVMEPROM_CALL {
    local($x) = @_;
    eval " &asm  &volatile ( &__CONCAT(\"trap #15; .short \",  &__STRING($x)) )";
}
sub MVMEPROM_NOARG {
    eval " &asm  &volatile (\"clrl sp@-\")";
}
sub MVMEPROM_ARG1 {
    local($arg) = @_;
    eval " &asm  &volatile (\"movel %0, sp@-\"::\"d\" ($arg))";
}
sub MVMEPROM_ARG2 {
    local($arg) = @_;
    eval " &asm  &volatile (\"movel %0, sp@-\"::\"d\" ($arg))";
}
sub MVMEPROM_GETRES {
    local($ret) = @_;
    eval " &asm  &volatile (\"movel sp@+,%0\": \"=d\" ($ret):)";
}
sub MVMEPROM_RETURN {
    local($ret) = @_;
    eval " &MVMEPROM_GETRES($ret);  &return ($ret);";
}
sub MVMEPROM_RETURN_BYTE {
    local($ret) = @_;
    eval " &MVMEPROM_GETRES($ret);  &return(($ret >> 24) & 0xff);";
}
sub MVMEPROM_STATRET {
    local($ret) = @_;
    eval " &MVMEPROM_GETRES($ret);  &return (!($ret & 0x4));";
}
sub MVMEPROM_REG_DEVLUN {"d0";}
sub MVMEPROM_REG_CTRLLUN {"d1";}
sub MVMEPROM_REG_FLAGS {"d4";}
sub MVMEPROM_REG_CTRLADDR {"a0";}
sub MVMEPROM_REG_ENTRY {"a1";}
sub MVMEPROM_REG_CONFBLK {"a2";}
sub MVMEPROM_REG_NBARGSTART {"a3";}
sub MVMEPROM_REG_NBARGEND {"a4";}
sub MVMEPROM_REG_ARGSTART {"a5";}
sub MVMEPROM_REG_ARGEND {"a6";}
if (!defined &RB_NOSYM) {
    eval 'sub RB_NOSYM {0x400;}';
}
1;
