sub _MACHINE {"mvme68k";}
sub MACHINE {"mvme68k";}
sub _MACHINE_ARCH {"m68k";}
sub MACHINE_ARCH {"m68k";}
sub MID_MACHINE { &MID_M68K;}
sub ALIGNBYTES {($sizeof{'int'} - 1);}
sub ALIGN {
    local($p) = @_;
    eval "((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES)";
}
sub PGSHIFT {12;}
sub NBPG {(1 <<  &PGSHIFT);}
sub PGOFSET {( &NBPG-1);}
sub NPTEPG {( &NBPG/($sizeof{ &pt_entry_t}));}
sub SEGSHIFT {22;}
sub NBSEG {(1 <<  &SEGSHIFT);}
sub SEGOFSET {( &NBSEG-1);}
sub KERNBASE {0x00000000;}
sub KERNTEXTOFF {0x00010000;}
sub BTOPKERNBASE {( &KERNBASE >>  &PGSHIFT);}
sub DEV_BSHIFT {9;}
sub DEV_BSIZE {(1 <<  &DEV_BSHIFT);}
sub BLKDEV_IOSIZE {2048;}
sub MAXPHYS {(64 * 1024);}
sub CLSIZELOG2 {0;}
sub CLSIZE {(1 <<  &CLSIZELOG2);}
sub SSIZE {1;}
sub SINCR {1;}
sub UPAGES {2;}
sub USPACE {( &UPAGES *  &NBPG);}
sub MSIZE {128;}
sub MCLSHIFT {11;}
sub MCLBYTES {(1 <<  &MCLSHIFT);}
sub MCLOFSET {( &MCLBYTES - 1);}
if (!defined &NMBCLUSTERS) {
    if (defined &GATEWAY) {
	eval 'sub NMBCLUSTERS {2048;}';
    }
    else {
	eval 'sub NMBCLUSTERS {1024;}';
    }
}
if (!defined &NKMEMCLUSTERS) {
    eval 'sub NKMEMCLUSTERS {(2048 * 1024 /  &CLBYTES);}';
}
sub ctod {
    local($x) = @_;
    eval "(($x) << ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub dtoc {
    local($x) = @_;
    eval "(($x) >> ( &PGSHIFT -  &DEV_BSHIFT))";
}
sub ctob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
sub btoc {
    local($x) = @_;
    eval "((($x) +  &PGOFSET) >>  &PGSHIFT)";
}
sub dbtob {
    local($x) = @_;
    eval "(($x) <<  &DEV_BSHIFT)";
}
sub btodb {
    local($x) = @_;
    eval "(($x) >>  &DEV_BSHIFT)";
}
sub bdbtofsb {
    local($bn) = @_;
    eval "(($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE))";
}
sub m68k_round_page {
    local($x) = @_;
    eval "(((($x)) +  &PGOFSET) & ~ &PGOFSET)";
}
sub m68k_trunc_page {
    local($x) = @_;
    eval "(($x) & ~ &PGOFSET)";
}
sub m68k_btop {
    local($x) = @_;
    eval "(($x) >>  &PGSHIFT)";
}
sub m68k_ptob {
    local($x) = @_;
    eval "(($x) <<  &PGSHIFT)";
}
require 'machine/psl.ph';
sub _spl {
    local($s) = @_;
    eval "({  &register 'int'  &_spl_r;  &__asm  &__volatile (\"clrl %0; movew sr,%0; movew %1,sr\" : \"&=d\" ( &_spl_r) : \"di\" ($s));  &_spl_r; })";
}
sub spl1 {
    eval " &_spl( &PSL_S| &PSL_IPL1)";
}
sub spl2 {
    eval " &_spl( &PSL_S| &PSL_IPL2)";
}
sub spl3 {
    eval " &_spl( &PSL_S| &PSL_IPL3)";
}
sub spl4 {
    eval " &_spl( &PSL_S| &PSL_IPL4)";
}
sub spl5 {
    eval " &_spl( &PSL_S| &PSL_IPL5)";
}
sub spl6 {
    eval " &_spl( &PSL_S| &PSL_IPL6)";
}
sub spl7 {
    eval " &_spl( &PSL_S| &PSL_IPL7)";
}
sub splsoftclock {
    eval " &spl1()";
}
sub splsoftnet {
    eval " &spl1()";
}
sub splbio {
    eval " &spl2()";
}
sub splnet {
    eval " &spl3()";
}
sub splimp {
    eval " &spl3()";
}
sub spltty {
    eval " &spl3()";
}
sub splclock {
    eval " &spl5()";
}
sub splstatclock {
    eval " &spl5()";
}
sub splhigh {
    eval " &spl7()";
}
sub splsched {
    eval " &spl7()";
}
sub splx {
    local($s) = @_;
    eval "($s &  &PSL_IPL ?  &_spl($s) :  &spl0())";
}
if (defined &_KERNEL) {
    eval 'sub DELAY {
        local($n) = @_;
        eval " &delay($n)";
    }';
}
1;
