# $Id: yacc.mk,v 1.3 2011/06/08 07:06:18 sjg Exp $

# this file contains rules to DTRT when SRCS contains foo.y or foo.c
# when only a foo.y exists.

YACC?= yacc
YFLAGS?= -v -t
RM?= rm

YACC.y?= ${YACC} ${YFLAGS}

.if ${YACC.y:M-d} == ""
.y.c:
	${YACC.y} ${.IMPSRC}
	[ ! -s y.tab.c ] || mv y.tab.c ${.TARGET}
	${RM} -f y.tab.*
.else
.y.h:
	${YACC.y} ${.IMPSRC}
	[ ! -s y.tab.c ] || mv y.tab.c ${.TARGET:T:R}.c
	touch ${.TARGET:T:R}.c
.ifndef NO_RENAME_Y_TAB_H
	[ ! -s y.tab.h ] || cmp -s y.tab.h ${.TARGET:T:R}.h \
		|| mv y.tab.h ${.TARGET:T:R}.h
	${RM} -f y.tab.*
.else
	${RM} -f y.tab.[!h]
.endif

# let the .y.h rule do the work
.y.c:	${.TARGET:T:R}.h
	true
.endif

beforedepend:	${SRCS:T:M*.y:S/.y/.c/g}

CLEANFILES+= ${SRCS:T:M*.y:S/.y/.[ch]/g}
CLEANFILES+= y.tab.[ch]
