.\" $XFree86: xc/programs/Xserver/hw/xwin/XWin.man,v 1.7 2003/10/02 13:30:09 eich Exp $
.TH XWIN 1 __vendorversion__
.SH NAME
XWin \- X Server for the Cygwin environment on Microsoft Windows
.SH SYNOPSIS
.B XWin
[ options ] ...
.SH DESCRIPTION
.I XWin
is an X Server for the X Window System on the Cygwin environment
running on Microsoft Windows.
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXWin\fP accepts the following command line switches:
.TP 8
.B "\-depth \fIdepth\fP"
Specify the color depth, in bits per pixel, to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.
.TP 8
.B "\-emulate3buttons \fItimeout\fP"
Emulate a three button mouse; pressing both buttons within
.I timeout
milliseconds causes an emulated middle button press.  The default 
.I timeout
is 50 milliseconds.
.TP 8
.B "\-engine \fIengine_type_id\fP"
Override the server's automatically supported engine type.  This
parameter will be ignored if the specified engine type is not
supported on the current system.  The supported engine type ids are 1
- Shadow GDI, 2 - Shadow DirectDraw, and 4 - Shadow DirectDraw4.
Additionally, there is a barely functional experimental engine type id
16 - Native GDI.
.TP 8
.B \-fullscreen
Run the server in fullscreen mode, as opposed to the default windowed
mode.
.TP 8
.B "\-refresh \fIrate_in_Hz\fP"
Specify an optional refresh rate to use when running in
fullscreen with a DirectDraw engine.  This parameter is ignored if
\fB\-fullscreen\fP is not specified.
.TP 8
.B "\-screen \fIscreen_number\fP \fIwidth\fP \fIheight\fP"
Sets the display resolution for the X server to use on screen
.I screen_number.
.TP 8
.B \-nodecoration
Draw the Cygwin/XFree86 window without a border or title bar.
.TP 8
.B \-rootless
EXPERIMENTAL: Run Cygwin/XFree86 in pseduo-rootless mode.
.TP 8
.B \-lesspointer
Hide the Windows mouse pointer when over an inactive XFree86 window
.TP 8
.B \-scrollbars
In windowed mode, allow screens bigger than the Windows desktop.
Moreover, if the window has decorations, one can now resize it.
.TP 8
.B "\-clipupdates \fInum_boxes\fP"
Specify an optional threshold, above which the boxes in a shadow
update operation will be collected into a GDI clipping region.  The
clipping region is then used to do a single bit block transfer that is
constrained to the updated area by the clipping region.  There is some
overhead involved in creating, installing, destroying, and removing
the clipping region, thus there may not be much benefit for a small
number of boxes (less than 10).  It is even possible that this
functionality does not provide a benefit at any number of boxes; we
can only determine the usefullness of this feature through testing.
This parameter works in conjunction with engines 1, 2, and 4 (Shadow
GDI, Shadow DirectDraw, and Shadow DirectDraw Non-Locking,
respectively).
.TP 8
.B \-emulatepseudo
Create a depth 8 PseudoColor visual when running in depths 15, 16, 24,
or 32, collectively known as TrueColor depths.  The PseudoColor visual
does not have correct colors, and it may crash, but it at least allows
you to run your PseudoColor application in TrueColor modes.
.TP 8
.B \-[no]unixkill
Ctrl+Alt+Backspace exits the X Server
.TP 8
.B \-[no]winkill
Alt+F4 exits the X Server
.SH "SEE ALSO"
.PP
X(__miscmansuffix__), Xserver(1), xdm(1), xinit(1), XWinrc(5)
.SH BUGS
.I XWin
and this man page still have many limitations. Some of the more obvious
ones are:
.br
- The display mode can not be changed once the X server has started.
.PP
.SH AUTHORS
XFree86 was originally ported to Cygwin by Dakshinamurthy Karra,
Dr. Peter Busch, John Fortin, and Suhaib Siddiqi.
.I XWin
is maintained by the Cygwin/XFree86 project, with hosting services
provided by RedHat.
.PP
The following members, in alphabetical order by last name, of the
Cygwin/XFree86 Team contributed to the XFree86 4.1.0 release:
.PP
Robert Collins - Cygwin developer, miscellaneous
.br
Christopher Faylor - Management of hosting services, general
programming guru
.br
Alexander Gottwald - AltGr handling for non-U.S. keyboards
.br
Alan Hourihane - XFree86 developer, patch reviewer, general programming guru
.br
Pierre A Humblet - Debugging of socket-related crashes, developer
.br
Harold L Hunt II - Project leader, lead developer, documentation,
and website updates
.br
Suhaib Siddiqi - Originator of the project







