/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;

public abstract class AbstractConferenceModificationIQ<I extends AbstractConferenceModificationIQ>
extends IQ {
    public static final String NAMESPACE = "jitsi:colibri2";

    protected AbstractConferenceModificationIQ(Builder<I> b, String element) {
        super(b, element, NAMESPACE);
        for (AbstractConferenceEntity ce : b.conferenceEntities) {
            this.addExtension(ce);
        }
    }

    @NotNull
    public List<Colibri2Endpoint> getEndpoints() {
        return this.getExtensions(Colibri2Endpoint.class);
    }

    @NotNull
    public List<Colibri2Relay> getRelays() {
        return this.getExtensions(Colibri2Relay.class);
    }

    public static abstract class Builder<I extends AbstractConferenceModificationIQ>
    extends IqBuilder<Builder<I>, I> {
        private final List<AbstractConferenceEntity> conferenceEntities = new ArrayList<AbstractConferenceEntity>();

        protected Builder(IqData iqCommon) {
            super((AbstractIqBuilder)iqCommon);
        }

        protected Builder(XMPPConnection connection) {
            super(connection);
        }

        protected Builder(String stanzaId) {
            super(stanzaId);
        }

        public Builder<I> addConferenceEntity(AbstractConferenceEntity entity) {
            this.conferenceEntities.add(entity);
            return this;
        }

        public Builder<I> addEndpoint(Colibri2Endpoint ep) {
            return this.addConferenceEntity(ep);
        }

        public Builder<I> addRelay(Colibri2Relay r) {
            return this.addConferenceEntity(r);
        }

        @Contract(value=" -> new")
        @NotNull
        public abstract I build();

        public Builder<I> getThis() {
            return this;
        }
    }
}

