/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugins.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugins.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.functions.MavenProjects;
import org.apache.maven.plugins.assembly.functions.ModuleSetConsumer;
import org.apache.maven.plugins.assembly.model.Assemblies;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.FilterUtils;
import org.apache.maven.plugins.assembly.utils.ProjectUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AssemblyArchiverPhase.class, hint="module-sets")
public class ModuleSetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase,
PhaseOrder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @Requirement
    private ProjectBuilder projectBuilder;
    @Requirement
    private ArchiverManager archiverManager;
    @Requirement
    private DependencyResolver dependencyResolver;

    public ModuleSetAssemblyPhase() {
    }

    public ModuleSetAssemblyPhase(ProjectBuilder projectBuilder, DependencyResolver dependencyResolver, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.dependencyResolver = dependencyResolver;
        this.enableLogging(logger);
    }

    public static List<DependencySet> getDependencySets(ModuleBinaries binaries) {
        List<DependencySet> depSets = binaries.getDependencySets();
        if ((depSets == null || depSets.isEmpty()) && binaries.isIncludeDependencies()) {
            DependencySet impliedDependencySet = new DependencySet();
            impliedDependencySet.setOutputDirectory(binaries.getOutputDirectory());
            impliedDependencySet.setFileMode(binaries.getFileMode());
            impliedDependencySet.setDirectoryMode(binaries.getDirectoryMode());
            impliedDependencySet.setExcludes(binaries.getExcludes());
            impliedDependencySet.setIncludes(binaries.getIncludes());
            impliedDependencySet.setUnpack(binaries.isUnpack());
            depSets = Collections.singletonList(impliedDependencySet);
        }
        return depSets;
    }

    @Nonnull
    public static Set<MavenProject> getModuleProjects(ModuleSet moduleSet, AssemblerConfigurationSource configSource, Logger logger) throws ArchiveCreationException {
        MavenProject project = configSource.getProject();
        Set<MavenProject> moduleProjects = null;
        if (moduleSet.isUseAllReactorProjects()) {
            if (!moduleSet.isIncludeSubModules()) {
                moduleProjects = new LinkedHashSet<MavenProject>(configSource.getReactorProjects());
            }
            project = configSource.getReactorProjects().get(0);
        }
        if (moduleProjects == null) {
            try {
                moduleProjects = ProjectUtils.getProjectModules(project, configSource.getReactorProjects(), moduleSet.isIncludeSubModules(), logger);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error retrieving module-set for project: " + project.getId() + ": " + e.getMessage(), e);
            }
        }
        return FilterUtils.filterProjects(moduleProjects, moduleSet.getIncludes(), moduleSet.getExcludes(), true, logger);
    }

    @Override
    public void execute(final Assembly assembly, final Archiver archiver, final AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        Assemblies.forEachModuleSet(assembly, new ModuleSetConsumer(){

            @Override
            public void accept(ModuleSet resolvedModule) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
                ModuleSetAssemblyPhase.this.validate(resolvedModule, configSource);
                Set<MavenProject> moduleProjects = ModuleSetAssemblyPhase.getModuleProjects(resolvedModule, configSource, ModuleSetAssemblyPhase.this.getLogger());
                ModuleSources sources = resolvedModule.getSources();
                ModuleSetAssemblyPhase.this.addModuleSourceFileSets(sources, moduleProjects, archiver, configSource);
                ModuleBinaries binaries = resolvedModule.getBinaries();
                ModuleSetAssemblyPhase.this.addModuleBinaries(assembly, resolvedModule, binaries, moduleProjects, archiver, configSource);
            }
        });
    }

    private void validate(ModuleSet moduleSet, AssemblerConfigurationSource configSource) {
        List<MavenProject> projects;
        if (moduleSet.getSources() == null && moduleSet.getBinaries() == null) {
            this.getLogger().warn("Encountered ModuleSet with no sources or binaries specified. Skipping.");
        }
        if (moduleSet.isUseAllReactorProjects() && !moduleSet.isIncludeSubModules()) {
            this.getLogger().warn("includeSubModules == false is incompatible with useAllReactorProjects. Ignoring.\n\nTo refactor, remove the <includeSubModules/> flag, and use the <includes/> and <excludes/> sections to fine-tune the modules included.");
        }
        if ((projects = configSource.getReactorProjects()) != null && projects.size() > 1 && projects.indexOf(configSource.getProject()) == 0 && moduleSet.getBinaries() != null) {
            this.getLogger().warn("[DEPRECATION] moduleSet/binaries section detected in root-project assembly.\n\nMODULE BINARIES MAY NOT BE AVAILABLE FOR THIS ASSEMBLY!\n\n To refactor, move this assembly into a child project and use the flag <useAllReactorProjects>true</useAllReactorProjects> in each moduleSet.");
        }
        if (moduleSet.getSources() != null) {
            ModuleSources sources = moduleSet.getSources();
            if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
                this.getLogger().warn("[DEPRECATION] Use of <moduleSources/> as a file-set is deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            } else if (!sources.isUseDefaultExcludes()) {
                this.getLogger().warn("[DEPRECATION] Use of directoryMode, fileMode, or useDefaultExcludes elements directly within <moduleSources/> are all deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            }
        }
    }

    void addModuleBinaries(Assembly assembly, ModuleSet moduleSet, ModuleBinaries binaries, Set<MavenProject> projects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        if (binaries == null) {
            return;
        }
        LinkedHashSet<MavenProject> moduleProjects = new LinkedHashSet<MavenProject>();
        MavenProjects.select(projects, "pom", MavenProjects.log(this.getLogger()), MavenProjects.addTo(moduleProjects));
        String classifier = binaries.getAttachmentClassifier();
        HashMap<MavenProject, Artifact> chosenModuleArtifacts = new HashMap<MavenProject, Artifact>();
        for (MavenProject project : moduleProjects) {
            Artifact artifact;
            if (classifier == null) {
                this.getLogger().debug("Processing binary artifact for module project: " + project.getId());
                artifact = project.getArtifact();
            } else {
                this.getLogger().debug("Processing binary attachment: " + classifier + " for module project: " + project.getId());
                artifact = MavenProjects.findArtifactByClassifier(project, classifier);
                if (artifact == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find attachment with classifier: " + classifier + " in module project: " + project.getId() + ". Please exclude this module from the module-set.");
                }
            }
            chosenModuleArtifacts.put(project, artifact);
            this.addModuleArtifact(artifact, project, archiver, configSource, binaries);
        }
        List<DependencySet> depSets = ModuleSetAssemblyPhase.getDependencySets(binaries);
        if (depSets != null) {
            Map<DependencySet, Set<Artifact>> dependencySetSetMap = this.dependencyResolver.resolveDependencySets(assembly, moduleSet, configSource, depSets);
            for (DependencySet ds : depSets) {
                ds.setUseProjectArtifact(false);
            }
            List<MavenProject> validateModuleVersions = this.validateModuleVersions(moduleProjects);
            if (!validateModuleVersions.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("The current modules seemed to be having different versions.");
                sb.append(LINE_SEPARATOR);
                for (MavenProject mavenProject : validateModuleVersions) {
                    sb.append(" --> ");
                    sb.append(mavenProject.getId());
                    sb.append(LINE_SEPARATOR);
                }
                this.getLogger().warn(sb.toString());
            }
            for (MavenProject moduleProject : moduleProjects) {
                this.getLogger().debug("Processing binary dependencies for module project: " + moduleProject.getId());
                for (Map.Entry<DependencySet, Set<Artifact>> dependencySetSetEntry : dependencySetSetMap.entrySet()) {
                    AddDependencySetsTask task = new AddDependencySetsTask(Collections.singletonList(dependencySetSetEntry.getKey()), dependencySetSetEntry.getValue(), moduleProject, this.projectBuilder, this.getLogger());
                    task.setModuleProject(moduleProject);
                    task.setModuleArtifact((Artifact)chosenModuleArtifacts.get(moduleProject));
                    task.setDefaultOutputDirectory(binaries.getOutputDirectory());
                    task.setDefaultOutputFileNameMapping(binaries.getOutputFileNameMapping());
                    task.execute(archiver, configSource);
                }
            }
        }
    }

    private List<MavenProject> validateModuleVersions(Set<MavenProject> moduleProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        if (moduleProjects != null && !moduleProjects.isEmpty()) {
            String version = moduleProjects.iterator().next().getVersion();
            this.getLogger().debug("First version:" + version);
            for (MavenProject mavenProject : moduleProjects) {
                this.getLogger().debug(" -> checking " + mavenProject.getId());
                if (version.equals(mavenProject.getVersion())) continue;
                result.add(mavenProject);
            }
        }
        return result;
    }

    void addModuleArtifact(Artifact artifact, MavenProject project, Archiver archiver, AssemblerConfigurationSource configSource, ModuleBinaries binaries) throws ArchiveCreationException, AssemblyFormattingException {
        int fileMode;
        if (artifact.getFile() == null) {
            throw new ArchiveCreationException("Artifact: " + artifact.getId() + " (included by module) does not have an artifact with a file. " + "Please ensure the package phase is run before the assembly is generated.");
        }
        AddArtifactTask task = new AddArtifactTask(artifact, this.getLogger(), null);
        task.setFileNameMapping(binaries.getOutputFileNameMapping());
        task.setOutputDirectory(binaries.getOutputDirectory());
        task.setProject(project);
        task.setModuleProject(project);
        task.setModuleArtifact(artifact);
        int dirMode = TypeConversionUtils.modeToInt(binaries.getDirectoryMode(), this.getLogger());
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(binaries.getFileMode(), this.getLogger())) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(binaries.isUnpack());
        if (binaries.isUnpack() && binaries.getUnpackOptions() != null) {
            task.setIncludes(binaries.getUnpackOptions().getIncludes());
            task.setExcludes(binaries.getUnpackOptions().getExcludes());
        }
        task.execute(archiver, configSource);
    }

    void addModuleSourceFileSets(ModuleSources sources, Set<MavenProject> moduleProjects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileSet> subFileSets;
        if (sources == null) {
            return;
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
            FileSet fs = new FileSet();
            fs.setOutputDirectory(sources.getOutputDirectory());
            fs.setIncludes(sources.getIncludes());
            fs.setExcludes(sources.getExcludes());
            fs.setUseDefaultExcludes(sources.isUseDefaultExcludes());
            fileSets.add(fs);
        }
        if ((subFileSets = sources.getFileSets()) == null || subFileSets.isEmpty()) {
            FileSet fs = new FileSet();
            fs.setDirectory("src");
            subFileSets = Collections.singletonList(fs);
        }
        fileSets.addAll(subFileSets);
        for (MavenProject moduleProject : moduleProjects) {
            this.getLogger().info("Processing sources for module project: " + moduleProject.getId());
            ArrayList<FileSet> moduleFileSets = new ArrayList<FileSet>();
            for (FileSet fileSet : fileSets) {
                moduleFileSets.add(this.createFileSet(fileSet, sources, moduleProject, configSource));
            }
            AddFileSetsTask task = new AddFileSetsTask(moduleFileSets);
            task.setProject(moduleProject);
            task.setModuleProject(moduleProject);
            task.setLogger(this.getLogger());
            task.execute(archiver, configSource);
        }
    }

    boolean isDeprecatedModuleSourcesConfigPresent(@Nonnull ModuleSources sources) {
        boolean result = false;
        if (sources.getOutputDirectory() != null) {
            result = true;
        } else if (sources.getIncludes() != null && !sources.getIncludes().isEmpty()) {
            result = true;
        } else if (sources.getExcludes() != null && !sources.getExcludes().isEmpty()) {
            result = true;
        }
        return result;
    }

    @Nonnull
    FileSet createFileSet(@Nonnull FileSet fileSet, @Nonnull ModuleSources sources, @Nonnull MavenProject moduleProject, @Nonnull AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        String destPath;
        FileSet fs = new FileSet();
        String sourcePath = fileSet.getDirectory();
        File moduleBasedir = moduleProject.getBasedir();
        if (sourcePath != null) {
            File sourceDir = new File(sourcePath);
            if (!sourceDir.isAbsolute()) {
                sourcePath = new File(moduleBasedir, sourcePath).getAbsolutePath();
            }
        } else {
            sourcePath = moduleBasedir.getAbsolutePath();
        }
        fs.setDirectory(sourcePath);
        fs.setDirectoryMode(fileSet.getDirectoryMode());
        ArrayList<String> excludes = new ArrayList<String>();
        List<String> originalExcludes = fileSet.getExcludes();
        if (originalExcludes != null && !originalExcludes.isEmpty()) {
            excludes.addAll(originalExcludes);
        }
        if (sources.isExcludeSubModuleDirectories()) {
            List modules = moduleProject.getModules();
            for (String moduleSubPath : modules) {
                excludes.add(moduleSubPath + "/**");
            }
        }
        fs.setExcludes(excludes);
        fs.setFiltered(fileSet.isFiltered());
        fs.setFileMode(fileSet.getFileMode());
        fs.setIncludes(fileSet.getIncludes());
        fs.setLineEnding(fileSet.getLineEnding());
        FixedStringSearchInterpolator moduleProjectInterpolator = AssemblyFormatUtils.moduleProjectInterpolator(moduleProject);
        FixedStringSearchInterpolator artifactProjectInterpolator = AssemblyFormatUtils.artifactProjectInterpolator(moduleProject);
        String destPathPrefix = "";
        if (sources.isIncludeModuleDirectory() && !(destPathPrefix = AssemblyFormatUtils.evaluateFileNameMapping(sources.getOutputDirectoryMapping(), moduleProject.getArtifact(), configSource.getProject(), moduleProject.getArtifact(), configSource, moduleProjectInterpolator, artifactProjectInterpolator)).endsWith("/")) {
            destPathPrefix = destPathPrefix + "/";
        }
        destPath = (destPath = fileSet.getOutputDirectory()) == null ? destPathPrefix : destPathPrefix + destPath;
        destPath = AssemblyFormatUtils.getOutputDirectory(destPath, configSource.getFinalName(), configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        fs.setOutputDirectory(destPath);
        this.getLogger().debug("module source directory is: " + sourcePath);
        this.getLogger().debug("module dest directory is: " + destPath + " (assembly basedir may be prepended)");
        return fs;
    }

    @Override
    public int order() {
        return 30;
    }
}

