/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address.packet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;

public class MultipleAddresses
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/address";
    public static final String ELEMENT = "addresses";
    public static final QName QNAME = new QName("http://jabber.org/protocol/address", "addresses");
    private final List<Address> addresses = new ArrayList<Address>();

    public void addAddress(Type type, Jid jid, String node, String desc, boolean delivered, String uri) {
        Address address = new Address(type);
        address.setJid(jid);
        address.setNode(node);
        address.setDescription(desc);
        address.setDelivered(delivered);
        address.setUri(uri);
        this.addresses.add(address);
    }

    public void setNoReply() {
        Address address = new Address(Type.noreply);
        this.addresses.add(address);
    }

    public List<Address> getAddressesOfType(Type type) {
        ArrayList<Address> answer = new ArrayList<Address>(this.addresses.size());
        for (Address address : this.addresses) {
            if (!address.getType().equals((Object)type)) continue;
            answer.add(address);
        }
        return answer;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder((ExtensionElement)this);
        buf.rightAngleBracket();
        for (Address address : this.addresses) {
            buf.append(address.toXML());
        }
        buf.closeElement((NamedElement)this);
        return buf;
    }

    public static final class Address
    implements ExtensionElement {
        public static final String ELEMENT = "address";
        private final Type type;
        private Jid jid;
        private String node;
        private String description;
        private boolean delivered;
        private String uri;

        private Address(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public Jid getJid() {
            return this.jid;
        }

        private void setJid(Jid jid) {
            this.jid = jid;
        }

        public String getNode() {
            return this.node;
        }

        private void setNode(String node) {
            this.node = node;
        }

        public String getDescription() {
            return this.description;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        public boolean isDelivered() {
            return this.delivered;
        }

        private void setDelivered(boolean delivered) {
            this.delivered = delivered;
        }

        public String getUri() {
            return this.uri;
        }

        private void setUri(String uri) {
            this.uri = uri;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return MultipleAddresses.NAMESPACE;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
            buf.attribute("type", (Enum)this.type);
            buf.optAttribute("jid", (CharSequence)this.jid);
            buf.optAttribute("node", this.node);
            buf.optAttribute("desc", this.description);
            if (this.description != null && this.description.trim().length() > 0) {
                buf.append((CharSequence)" desc=\"");
                buf.append((CharSequence)this.description).append('\"');
            }
            buf.optBooleanAttribute("delivered", this.delivered);
            buf.optAttribute("uri", this.uri);
            buf.closeEmptyElement();
            return buf;
        }
    }

    public static enum Type {
        bcc,
        cc,
        noreply,
        replyroom,
        replyto,
        to,
        ofrom;

    }
}

