/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.filter;

import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.client.core.exception.NexusClientAccessForbiddenException;
import org.sonatype.nexus.client.core.exception.NexusClientBadRequestException;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;
import org.sonatype.nexus.client.core.exception.NexusClientNotFoundException;
import org.sonatype.nexus.client.internal.msg.ErrorMessage;
import org.sonatype.nexus.client.internal.msg.ErrorResponse;

public class NexusClientExceptionsConverterFilter
extends ClientFilter {
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(request);
        this.throwIf404(response);
        this.throwIf403(response);
        this.throwIf400WithErrorMessage(response);
        this.throwIf400(response);
        return response;
    }

    private void throwIf400WithErrorMessage(ClientResponse response) {
        if (ClientResponse.Status.BAD_REQUEST.equals((Object)response.getClientResponseStatus())) {
            String body = this.getResponseBody(response);
            response.bufferEntity();
            ErrorResponse errorResponse = null;
            try {
                errorResponse = (ErrorResponse)response.getEntity(ErrorResponse.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorResponse != null) {
                ArrayList errors = Lists.newArrayList();
                for (ErrorMessage message : errorResponse.getErrors()) {
                    errors.add(new NexusClientErrorResponseException.ErrorMessage(message.getId(), message.getMsg()));
                }
                throw new NexusClientErrorResponseException(response.getClientResponseStatus().getReasonPhrase(), body, errors);
            }
        }
    }

    private void throwIf400(ClientResponse response) {
        if (ClientResponse.Status.BAD_REQUEST.equals((Object)response.getClientResponseStatus())) {
            throw new NexusClientBadRequestException(response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
    }

    private void throwIf403(ClientResponse response) {
        if (ClientResponse.Status.FORBIDDEN.equals((Object)response.getClientResponseStatus())) {
            throw new NexusClientAccessForbiddenException(response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
    }

    private void throwIf404(ClientResponse response) {
        if (ClientResponse.Status.NOT_FOUND.equals((Object)response.getClientResponseStatus())) {
            throw new NexusClientNotFoundException(response.getClientResponseStatus().getReasonPhrase(), this.getResponseBody(response));
        }
    }

    private String getResponseBody(ClientResponse response) {
        try {
            byte[] body = IOUtils.toByteArray((InputStream)response.getEntityInputStream());
            response.setEntityInputStream((InputStream)new ByteArrayInputStream(body));
            return IOUtils.toString((byte[])body, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Jersey unexpectedly refused to rewind buffered entity.");
        }
    }
}

