/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.checkstyle.AbstractCheckstyleReport;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="checkstyle", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckstyleReport
extends AbstractCheckstyleReport {
    protected MavenProject getProject() {
        return this.project;
    }

    @Override
    public void executeReport(Locale locale) throws MavenReportException {
        super.executeReport(locale);
    }

    @Override
    protected CheckstyleExecutorRequest createRequest() throws MavenReportException {
        CheckstyleExecutorRequest request = new CheckstyleExecutorRequest();
        request.setConsoleListener(this.getConsoleListener()).setConsoleOutput(this.consoleOutput).setExcludes(this.excludes).setFailsOnError(this.failsOnError).setIncludes(this.includes).setResourceIncludes(this.resourceIncludes).setResourceExcludes(this.resourceExcludes).setIncludeResources(this.includeResources).setIncludeTestResources(this.includeTestResources).setIncludeTestSourceDirectory(this.includeTestSourceDirectory).setListener(this.getListener()).setProject(this.project).setSourceDirectories(this.getSourceDirectories()).setResources(this.resources).setStringOutputStream(this.stringOutputStream).setSuppressionsLocation(this.suppressionsLocation).setTestSourceDirectories(this.getTestSourceDirectories()).setConfigLocation(this.configLocation).setPropertyExpansion(this.propertyExpansion).setHeaderLocation(this.headerLocation).setCacheFile(this.cacheFile).setSuppressionsFileExpression(this.suppressionsFileExpression).setEncoding(this.encoding).setPropertiesLocation(this.propertiesLocation);
        return request;
    }

    public String getOutputName() {
        return "checkstyle";
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        for (File sourceDirectory : this.getSourceDirectories()) {
            if (!sourceDirectory.exists()) continue;
            return true;
        }
        if (this.includeTestSourceDirectory) {
            for (File testSourceDirectory : this.getTestSourceDirectories()) {
                if (!testSourceDirectory.exists()) continue;
                return true;
            }
        }
        return this.includeResources && this.hasResources(this.resources) || this.includeTestResources && this.hasResources(this.testResources);
    }

    private boolean hasResources(List<Resource> resources) {
        for (Resource resource : resources) {
            if (!new File(resource.getDirectory()).exists()) continue;
            return true;
        }
        return false;
    }
}

