/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;
import io.pkts.packet.sip.impl.ImmutableSipRequest;
import io.pkts.packet.sip.impl.ImmutableSipResponse;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipUserHostInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SipParser {
    private static final String UNABLE_TO_READ_FROM_STREAM = "Unable to read from stream";
    public static final int MAX_LOOK_AHEAD = 1024;
    public static final Buffer INVITE = Buffers.wrap((String)"INVITE");
    public static final Buffer ACK = Buffers.wrap((String)"ACK");
    public static final Buffer CANCEL = Buffers.wrap((String)"CANCEL");
    public static final Buffer BYE = Buffers.wrap((String)"BYE");
    public static final Buffer SUBSCRIBE = Buffers.wrap((String)"SUBSCRIBE");
    public static final Buffer NOTIFY = Buffers.wrap((String)"NOTIFY");
    public static final Buffer PUBLISH = Buffers.wrap((String)"PUBLISH");
    public static final Buffer INFO = Buffers.wrap((String)"INFO");
    public static final Buffer OPTIONS = Buffers.wrap((String)"OPTIONS");
    public static final Buffer REGISTER = Buffers.wrap((String)"REGISTER");
    public static final Buffer PRACK = Buffers.wrap((String)"PRACK");
    public static final Buffer REFER = Buffers.wrap((String)"REFER");
    public static final Buffer MESSAGE = Buffers.wrap((String)"MESSAGE");
    public static final Buffer UPDATE = Buffers.wrap((String)"UPDATE");
    public static final Buffer TAG = Buffers.wrap((String)"tag");
    public static final Buffer USER = Buffers.wrap((String)"user");
    public static final Buffer TTL = Buffers.wrap((String)"ttl");
    public static final Buffer MADDR = Buffers.wrap((String)"maddr");
    public static final Buffer METHOD = Buffers.wrap((String)"method");
    public static final Buffer TRANSPORT = Buffers.wrap((String)"transport");
    public static final Buffer TRANSPORT_EQ = Buffers.wrap((String)"transport=");
    public static final Buffer SIP2_0 = Buffers.wrap((String)"SIP/2.0");
    public static final Buffer SIP2_0_SLASH = Buffers.wrap((String)"SIP/2.0/");
    public static final Buffer SCHEME_SIP = Buffers.wrap((String)"sip");
    public static final Buffer SCHEME_SIP_COLON = Buffers.wrap((String)"sip:");
    public static final Buffer SCHEME_SIPS = Buffers.wrap((String)"sips");
    public static final Buffer SCHEME_SIPS_COLON = Buffers.wrap((String)"sips:");
    public static final Buffer SCHEME_TEL = Buffers.wrap((String)"tel");
    public static final Buffer SCHEME_TEL_COLON = Buffers.wrap((String)"tel:");
    public static final byte AT = 64;
    public static final byte COLON = 58;
    public static final byte SEMI = 59;
    public static final byte DOUBLE_QOUTE = 34;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte SP = 32;
    public static final byte HTAB = 9;
    public static final byte DASH = 45;
    public static final byte PERIOD = 46;
    public static final byte COMMA = 44;
    public static final byte EXCLAMATIONPOINT = 33;
    public static final byte PERCENT = 37;
    public static final byte STAR = 42;
    public static final byte UNDERSCORE = 95;
    public static final byte QUESTIONMARK = 63;
    public static final byte PLUS = 43;
    public static final byte BACKTICK = 96;
    public static final byte TICK = 39;
    public static final byte TILDE = 126;
    public static final byte EQ = 61;
    public static final byte SLASH = 47;
    public static final byte BACK_SLASH = 92;
    public static final byte LPAREN = 40;
    public static final byte RPAREN = 41;
    public static final byte RAQUOT = 62;
    public static final byte LAQUOT = 60;
    public static final byte DQUOT = 34;
    public static final Buffer UDP = Buffers.wrap((String)"udp");
    public static final Buffer TCP = Buffers.wrap((String)"tcp");
    public static final Buffer TLS = Buffers.wrap((String)"tls");
    public static final Buffer SCTP = Buffers.wrap((String)"sctp");
    public static final Buffer WS = Buffers.wrap((String)"ws");
    public static final Buffer WSS = Buffers.wrap((String)"wss");
    public static final Map<Buffer, Function<SipHeader, ? extends SipHeader>> framers = new HashMap<Buffer, Function<SipHeader, ? extends SipHeader>>();

    public static Function<SipHeader, ? extends SipHeader> getFramer(Buffer b) {
        Function<SipHeader, ? extends SipHeader> framer = framers.get(b);
        if (framer != null) {
            return framer;
        }
        for (Map.Entry<Buffer, Function<SipHeader, ? extends SipHeader>> entry : framers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase((Object)b)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void expectSIP2_0(Buffer buffer) throws SipParseException {
        SipParser.expect(buffer, 'S');
        SipParser.expect(buffer, 'I');
        SipParser.expect(buffer, 'P');
        SipParser.expect(buffer, '/');
        SipParser.expect(buffer, '2');
        SipParser.expect(buffer, '.');
        SipParser.expect(buffer, '0');
    }

    public static Buffer expectMethod(Buffer buffer) {
        return null;
    }

    public static boolean isUDP(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 85 && t.getByte(1) == 68 && t.getByte(2) == 80;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isTCP(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 84 && t.getByte(1) == 67 && t.getByte(2) == 80;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isTLS(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 84 && t.getByte(1) == 76 && t.getByte(2) == 83;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isWS(Buffer t) {
        try {
            return t.capacity() == 2 && t.getByte(0) == 87 && t.getByte(1) == 83;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isWSS(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 87 && t.getByte(1) == 83 && t.getByte(2) == 83;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isSCTP(Buffer t) {
        try {
            return t.capacity() == 4 && t.getByte(0) == 83 && t.getByte(1) == 67 && t.getByte(2) == 84 && t.getByte(3) == 80;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isUDPLower(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 117 && t.getByte(1) == 100 && t.getByte(2) == 112;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isTCPLower(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 116 && t.getByte(1) == 99 && t.getByte(2) == 112;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isTLSLower(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 116 && t.getByte(1) == 108 && t.getByte(2) == 115;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isWSLower(Buffer t) {
        try {
            return t.capacity() == 2 && t.getByte(0) == 119 && t.getByte(1) == 115;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isWSSLower(Buffer t) {
        try {
            return t.capacity() == 3 && t.getByte(0) == 119 && t.getByte(1) == 115 && t.getByte(2) == 115;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isSCTPLower(Buffer t) {
        try {
            return t.capacity() == 4 && t.getByte(0) == 115 && t.getByte(1) == 99 && t.getByte(2) == 116 && t.getByte(3) == 112;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void expectTel(Buffer buffer) throws SipParseException, IOException {
        SipParser.expect(buffer, 't');
        SipParser.expect(buffer, 'e');
        SipParser.expect(buffer, 'l');
        SipParser.expect(buffer, (byte)58);
    }

    public static boolean isSips(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        SipParser.expect(buffer, 's');
        SipParser.expect(buffer, 'i');
        SipParser.expect(buffer, 'p');
        byte b = buffer.readByte();
        if (b == 58) {
            return false;
        }
        if (b != 115) {
            throw new SipParseException(buffer.getReaderIndex() - 1, "Expected 's' since the only schemes accepted are \"sip\" and \"sips\"");
        }
        SipParser.expect(buffer, (byte)58);
        return true;
    }

    public static List<Buffer[]> consumeGenericParams(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        ArrayList<Buffer[]> params = new ArrayList<Buffer[]>();
        while (buffer.hasReadableBytes() && buffer.peekByte() == 59) {
            buffer.readByte();
            params.add(SipParser.consumeGenericParam(buffer));
        }
        return params;
    }

    public static Buffer[] consumeGenericParam(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        Buffer key = SipParser.consumeToken(buffer);
        Buffer value = null;
        if (key == null) {
            return new Buffer[2];
        }
        if (SipParser.consumeEQUAL(buffer) > 0) {
            value = SipParser.isNext(buffer, (byte)34) ? SipParser.consumeQuotedString(buffer) : SipParser.consumeToken(buffer);
        }
        return new Buffer[]{key, value};
    }

    public static boolean isNext(Buffer buffer, byte b) throws IOException {
        if (buffer.hasReadableBytes()) {
            byte actual = buffer.peekByte();
            return actual == b;
        }
        return false;
    }

    public static boolean isNextDigit(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        if (buffer.hasReadableBytes()) {
            char next = (char)buffer.peekByte();
            return next >= '0' && next <= '9';
        }
        return false;
    }

    public static Buffer expectDigit(Buffer buffer) throws SipParseException {
        int start = buffer.getReaderIndex();
        try {
            while (buffer.hasReadableBytes() && SipParser.isNextDigit(buffer)) {
                buffer.readByte();
            }
            if (start == buffer.getReaderIndex()) {
                throw new SipParseException(start, "Expected digit");
            }
            return buffer.slice(start, buffer.getReaderIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(start, "Expected digit but no more bytes to read");
        }
        catch (IOException e) {
            throw new SipParseException(start, "Expected digit unable to read from underlying stream");
        }
    }

    public static int expectHCOLON(Buffer buffer) throws SipParseException {
        int consumed = SipParser.expectHCOLONStreamFriendly(buffer);
        if (consumed == -1) {
            throw new IndexOutOfBoundsException();
        }
        return consumed;
    }

    public static int expectHCOLONStreamFriendly(Buffer buffer) throws SipParseException {
        try {
            int consumed = SipParser.consumeWS(buffer);
            if (!buffer.hasReadableBytes()) {
                return -1;
            }
            SipParser.expect(buffer, (byte)58);
            ++consumed;
            return consumed += SipParser.consumeSWSAfterHColon(buffer);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    public static int consumeSWSAfterHColon(Buffer buffer) throws IOException {
        int consumed = SipParser.consumeWS(buffer);
        if (!SipParser.isNext(buffer, (byte)13)) {
            consumed += SipParser.consumeSWS(buffer);
        }
        return consumed;
    }

    public static void expectSLASH(Buffer buffer) throws SipParseException {
        try {
            int count = SipParser.consumeSLASH(buffer);
            if (count == 0) {
                throw new SipParseException(buffer.getReaderIndex(), "Expected SLASH");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected SLASH but nothing more to read", e);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected SLASH but problem reading from stream", e);
        }
    }

    public static int consumeSLASH(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)47);
    }

    public static int expectWS(Buffer buffer) throws SipParseException {
        int consumed = 0;
        try {
            if (buffer.hasReadableBytes()) {
                byte b = buffer.getByte(buffer.getReaderIndex());
                if (b != 32 && b != 9) {
                    throw new SipParseException(buffer.getReaderIndex(), "Expected WS");
                }
            } else {
                throw new SipParseException(buffer.getReaderIndex(), "Expected WS but nothing more to read in the buffer");
            }
            buffer.readByte();
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
        return ++consumed;
    }

    public static int consumeSWS(Buffer buffer) {
        try {
            return SipParser.consumeLWS(buffer);
        }
        catch (SipParseException e) {
            return 0;
        }
    }

    public static int consumeSTAR(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)42);
    }

    public static int consumeEQUAL(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)61);
    }

    public static int consumeLPAREN(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)40);
    }

    public static int consumeRPAREN(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)41);
    }

    public static int consumeRAQUOT(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)62);
    }

    public static int consumeLAQUOT(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)60);
    }

    public static int consumeCOMMA(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)44);
    }

    public static int consumeSEMI(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)59);
    }

    public static int consumeCOLON(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        return SipParser.consumeSeparator(buffer, (byte)58);
    }

    public static int consumeLDQUOT(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        buffer.markReaderIndex();
        int consumed = SipParser.consumeSWS(buffer);
        if (!SipParser.isNext(buffer, (byte)34)) {
            buffer.resetReaderIndex();
            return 0;
        }
        buffer.readByte();
        return ++consumed;
    }

    public static int consumeRDQUOT(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        buffer.markReaderIndex();
        int consumed = 0;
        if (SipParser.isNext(buffer, (byte)34)) {
            buffer.readByte();
            ++consumed;
        } else {
            buffer.resetReaderIndex();
            return 0;
        }
        return consumed += SipParser.consumeSWS(buffer);
    }

    private static int consumeSeparator(Buffer buffer, byte b) throws IndexOutOfBoundsException, IOException {
        buffer.markReaderIndex();
        int consumed = SipParser.consumeSWS(buffer);
        if (SipParser.isNext(buffer, b)) {
            buffer.readByte();
            ++consumed;
        } else {
            buffer.resetReaderIndex();
            return 0;
        }
        return consumed += SipParser.consumeSWS(buffer);
    }

    public static Buffer expectToken(Buffer buffer) throws IndexOutOfBoundsException, IOException, SipParseException {
        Buffer token = SipParser.consumeToken(buffer);
        if (token == null) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected TOKEN");
        }
        return token;
    }

    public static Buffer consumeQuotedString(Buffer buffer) throws SipParseException, IOException {
        byte b;
        int start = buffer.getReaderIndex();
        SipParser.expect(buffer, (byte)34);
        while (buffer.hasReadableBytes() && (b = buffer.readByte()) != 34) {
            if (b != 92) continue;
            buffer.readByte();
        }
        int stop = buffer.getReaderIndex();
        buffer.setReaderIndex(start + 1);
        Buffer result = buffer.readBytes(stop - start - 2);
        buffer.setReaderIndex(stop);
        return result;
    }

    public static Buffer consumeDisplayName(Buffer buffer) throws IOException, SipParseException {
        if (SipParser.isNext(buffer, (byte)34)) {
            return SipParser.consumeQuotedString(buffer);
        }
        int count = SipParser.getTokenCount(buffer);
        if (count == 0) {
            return Buffers.EMPTY_BUFFER;
        }
        buffer.markReaderIndex();
        Buffer potentialDisplayName = buffer.readBytes(count);
        if (SipParser.isNext(buffer, (byte)58)) {
            buffer.resetReaderIndex();
            return Buffers.EMPTY_BUFFER;
        }
        return potentialDisplayName;
    }

    public static Buffer consumeAddressSpec(Buffer buffer) throws IndexOutOfBoundsException, IOException, SipParseException {
        buffer.markReaderIndex();
        int count = 0;
        boolean state = false;
        boolean done = false;
        while (buffer.hasReadableBytes() && !done) {
            byte b = buffer.readByte();
            if (!state && ++count > 99) {
                throw new SipParseException(buffer.getReaderIndex(), "No scheme found after 100 bytes, giving up");
            }
            if (count > 1024) {
                throw new SipParseException(buffer.getReaderIndex(), "Have not been able to find the entire addr-spec after " + count + " bytes, giving up");
            }
            if (!state && b == 58) {
                state = true;
                continue;
            }
            if (!state || b != 62 && b != 32 && b != 9 && b != 13 && b != 10) continue;
            done = true;
            --count;
        }
        buffer.resetReaderIndex();
        if (!state) {
            throw new SipParseException(buffer.getReaderIndex(), "No scheme found");
        }
        if (count > 0) {
            return buffer.readBytes(count);
        }
        return null;
    }

    public static SipUserHostInfo consumeUserInfoHostPort(Buffer buffer) throws SipParseException, IOException {
        return SipUserHostInfo.frame(buffer);
    }

    public static Buffer consumeSentProtocol(Buffer buffer) throws IOException, SipParseException {
        SipParser.expectSIP2_0(buffer);
        SipParser.expect(buffer, (byte)47);
        Buffer protocol = SipParser.consumeToken(buffer);
        if (protocol == null || protocol.isEmpty()) {
            throw new SipParseException(buffer.getReaderIndex(), "Expected transport");
        }
        return protocol;
    }

    public static Buffer consumeToken(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        int count = SipParser.getTokenCount(buffer);
        if (count == 0) {
            return null;
        }
        return buffer.readBytes(count);
    }

    public static Buffer consumeAlphaNum(Buffer buffer) throws IOException {
        int count = SipParser.getAlphaNumCount(buffer);
        if (count == 0) {
            return null;
        }
        return buffer.readBytes(count);
    }

    public static Object[] consumeVia(Buffer buffer) throws SipParseException, IOException {
        List<Buffer[]> params;
        Object[] result = new Object[4];
        int count = 0;
        int indexOfSemi = 0;
        int countOfColons = 0;
        int indexOfLastColon = 0;
        int readerIndexOfLastColon = 0;
        SipParser.consumeSWS(buffer);
        result[0] = SipParser.consumeSentProtocol(buffer);
        SipParser.consumeLWS(buffer);
        int index = buffer.getReaderIndex();
        while (indexOfSemi == 0 && buffer.hasReadableBytes() && ++count < 1024) {
            byte b = buffer.readByte();
            if (b == 59) {
                indexOfSemi = count;
                continue;
            }
            if (b != 58) continue;
            ++countOfColons;
            indexOfLastColon = count;
            readerIndexOfLastColon = buffer.getReaderIndex();
        }
        if (count == 0) {
            return null;
        }
        if (count == 1024) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to find the parameters part of the Via-header even after searching for 1024 bytes.");
        }
        if (indexOfSemi == 0) {
            throw new SipParseException(buffer.getReaderIndex(), "No via-parameters found. The Via-header MUST contain at least the branch parameter.");
        }
        buffer.setReaderIndex(index);
        if (countOfColons == 0 || countOfColons == 7) {
            result[1] = buffer.readBytes(indexOfSemi - 1);
        } else if (indexOfLastColon != 0 && (countOfColons == 1 || countOfColons == 8)) {
            result[1] = buffer.readBytes(indexOfLastColon - 1);
            buffer.readByte();
            result[2] = buffer.readBytes(indexOfSemi - indexOfLastColon - 1);
            if (result[2] == null || ((Buffer)result[2]).isEmpty()) {
                throw new SipParseException(readerIndexOfLastColon + 1, "Expected port after colon");
            }
        } else {
            throw new SipParseException(indexOfLastColon, "Found " + countOfColons + " which seems odd." + " Expecting 0, 1, 7 or 8 colons in the Via-host:port portion. Please check your traffic");
        }
        result[3] = params = SipParser.consumeGenericParams(buffer);
        return result;
    }

    public static Buffer[] consumeSentBye(Buffer buffer) throws SipParseException, IOException {
        int index = buffer.getReaderIndex();
        int count = 0;
        boolean done = false;
        boolean firstColon = false;
        boolean consumePort = false;
        while (!done && buffer.hasReadableBytes()) {
            byte b = buffer.readByte();
            ++count;
            if (firstColon && SipParser.isDigit(b)) {
                consumePort = true;
                done = true;
                count -= 2;
                continue;
            }
            if (firstColon) {
                firstColon = false;
                continue;
            }
            if (b == 58) {
                firstColon = true;
                continue;
            }
            if (b != 59) continue;
            --count;
            done = true;
        }
        if (count == 0) {
            return null;
        }
        buffer.setReaderIndex(index);
        Buffer host = buffer.readBytes(count);
        Buffer port = null;
        if (consumePort) {
            buffer.readByte();
            port = SipParser.consumePort(buffer);
        }
        return new Buffer[]{host, port};
    }

    public static Buffer consumePort(Buffer buffer) throws IOException {
        int count = 0;
        int index = buffer.getReaderIndex();
        boolean done = false;
        while (!done && buffer.hasReadableBytes()) {
            if (SipParser.isDigit(buffer.readByte())) {
                ++count;
                continue;
            }
            done = true;
        }
        buffer.setReaderIndex(index);
        if (count != 0) {
            return buffer.readBytes(count);
        }
        return null;
    }

    public static Buffer consumeHostname(Buffer buffer) throws IOException {
        return null;
    }

    public static Buffer consumeMType(Buffer buffer) throws SipParseException {
        try {
            return SipParser.consumeToken(buffer);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Tried to consume m-type but buffer ended abruptly", e);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Tried to consume m-type but problem reading from underlying stream", e);
        }
    }

    public static Buffer consumeMSubtype(Buffer buffer) throws SipParseException {
        try {
            return SipParser.consumeToken(buffer);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Tried to consume m-type but buffer ended abruptly", e);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Tried to consume m-type but problem reading from underlying stream", e);
        }
    }

    public static int getTokenCount(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        boolean done = false;
        int count = 0;
        buffer.markReaderIndex();
        while (buffer.hasReadableBytes() && !done) {
            boolean ok;
            byte b = buffer.readByte();
            boolean bl = ok = SipParser.isAlphaNum(b) || b == 45 || b == 46 || b == 33 || b == 37 || b == 42 || b == 95 || b == 43 || b == 96 || b == 39 || b == 126;
            if (ok) {
                ++count;
                continue;
            }
            done = true;
        }
        buffer.resetReaderIndex();
        return count;
    }

    public static int getAlphaNumCount(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        boolean done = false;
        int count = 0;
        int index = buffer.getReaderIndex();
        while (buffer.hasReadableBytes() && !done) {
            byte b = buffer.readByte();
            if (SipParser.isAlphaNum(b)) {
                ++count;
                continue;
            }
            done = true;
        }
        buffer.setReaderIndex(index);
        return count;
    }

    public static boolean isNextAlphaNum(Buffer buffer) throws IndexOutOfBoundsException, IOException {
        if (buffer.hasReadableBytes()) {
            byte b = buffer.peekByte();
            return SipParser.isAlphaNum(b);
        }
        return false;
    }

    public static boolean isHostPortCharacter(char ch) {
        return SipParser.isAlphaNum(ch) || ch == '-' || ch == '.' || ch == ':';
    }

    public static boolean isHostPortCharacter(byte b) {
        return SipParser.isHostPortCharacter((char)b);
    }

    public static boolean isAlphaNum(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAlphaNum(byte b) {
        return SipParser.isAlphaNum((char)b);
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isDigit(byte b) {
        return SipParser.isDigit((char)b);
    }

    public static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAlpha(byte b) {
        return SipParser.isAlpha((char)b);
    }

    public static int consumeLWS(Buffer buffer) throws SipParseException {
        int i = buffer.getReaderIndex();
        SipParser.consumeWS(buffer);
        if (SipParser.consumeCRLF(buffer) > 0) {
            SipParser.expectWS(buffer);
        }
        SipParser.consumeWS(buffer);
        if (buffer.getReaderIndex() == i) {
            throw new SipParseException(i, "Expected at least 1 WSP");
        }
        return buffer.getReaderIndex() - i;
    }

    public static int consumeCRLF(Buffer buffer) throws SipParseException {
        try {
            buffer.markReaderIndex();
            byte cr = buffer.readByte();
            byte lf = buffer.readByte();
            if (cr == 13 && lf == 10) {
                return 2;
            }
        }
        catch (IndexOutOfBoundsException cr) {
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
        buffer.resetReaderIndex();
        return 0;
    }

    public static void expect(Buffer buffer, byte expected) throws SipParseException, IOException {
        byte actual = buffer.readByte();
        if (actual != expected) {
            String actualStr = new String(new byte[]{actual}, Charset.forName("UTF-8"));
            String expectedStr = new String(new byte[]{expected});
            throw new SipParseException(buffer.getReaderIndex(), "Expected '" + expected + "' (" + expectedStr + ") got '" + actual + "' (" + actualStr + ")");
        }
    }

    public static int consumeWS(Buffer buffer) throws SipParseException {
        try {
            boolean done = false;
            int count = 0;
            while (buffer.hasReadableBytes() && !done) {
                if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9)) {
                    buffer.readByte();
                    ++count;
                    continue;
                }
                done = true;
            }
            return count;
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    public static void expect(Buffer buffer, char ch) throws SipParseException {
        try {
            short i = buffer.readUnsignedByte();
            if (i != ch) {
                throw new SipParseException(buffer.getReaderIndex(), "Expected '" + ch + "' got '" + i + "'");
            }
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    public static Buffer nextHeaderNameDontCheckHColon(Buffer buffer) {
        try {
            int startIndex = buffer.getReaderIndex();
            int nameIndex = 0;
            while (buffer.hasReadableBytes() && nameIndex == 0) {
                if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9) || SipParser.isNext(buffer, (byte)58)) {
                    nameIndex = buffer.getReaderIndex();
                    continue;
                }
                buffer.readByte();
            }
            if (nameIndex == 0) {
                buffer.setReaderIndex(startIndex);
                return null;
            }
            return buffer.slice(startIndex, nameIndex);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    public static Buffer nextHeaderName(Buffer buffer) throws SipParseException {
        Buffer name = SipParser.nextHeaderNameDontCheckHColon(buffer);
        if (name != null) {
            SipParser.expectHCOLON(buffer);
        }
        return name;
    }

    public static List<SipHeader> nextHeaders(Buffer buffer) throws SipParseException {
        try {
            int startIndex = buffer.getReaderIndex();
            int nameIndex = 0;
            while (buffer.hasReadableBytes() && nameIndex == 0) {
                if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9) || SipParser.isNext(buffer, (byte)58)) {
                    nameIndex = buffer.getReaderIndex();
                    continue;
                }
                buffer.readByte();
            }
            if (nameIndex == 0) {
                return null;
            }
            Buffer name = buffer.slice(startIndex, nameIndex);
            SipParser.expectHCOLON(buffer);
            List<Buffer> values = SipParser.readHeaderValues((Buffer)name, (Buffer)buffer).values;
            ArrayList<SipHeader> headers = new ArrayList<SipHeader>(values.size());
            for (Buffer value : values) {
                headers.add(new SipHeaderImpl(name, value));
            }
            return headers;
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    private static boolean isHeaderAllowingMultipleValues(Buffer headerName) {
        int size = headerName.getReadableBytes();
        if (size == 7) {
            return !SipParser.isSubjectHeader(headerName);
        }
        if (size == 5) {
            return !SipParser.isAllowHeader(headerName);
        }
        if (size == 4) {
            return !SipParser.isDateHeader(headerName);
        }
        if (size == 1) {
            return !SipParser.isAllowEventsHeaderShort(headerName);
        }
        if (size == 12) {
            return !SipParser.isAllowEventsHeader(headerName);
        }
        return true;
    }

    private static boolean isDateHeader(Buffer name) {
        try {
            return name.getByte(0) == 68 && name.getByte(1) == 97 && name.getByte(2) == 116 && name.getByte(3) == 101;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isAllowHeader(Buffer name) {
        try {
            return name.getByte(0) == 65 && name.getByte(1) == 108 && name.getByte(2) == 108 && name.getByte(3) == 111 && name.getByte(4) == 119;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isAllowEventsHeaderShort(Buffer name) {
        try {
            return name.getByte(0) == 117;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isAllowEventsHeader(Buffer name) {
        try {
            return name.getByte(0) == 65 && name.getByte(1) == 108 && name.getByte(2) == 108 && name.getByte(3) == 111 && name.getByte(4) == 119 && name.getByte(5) == 45 && name.getByte(6) == 69 && name.getByte(7) == 118 && name.getByte(8) == 101 && name.getByte(9) == 110 && name.getByte(10) == 116 && name.getByte(11) == 115;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isSubjectHeader(Buffer name) {
        try {
            return name.getByte(0) == 83 && name.getByte(1) == 117 && name.getByte(2) == 98 && name.getByte(3) == 106 && name.getByte(4) == 101 && name.getByte(5) == 99 && name.getByte(6) == 116;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static HeaderValueState readHeaderValues(HeaderValueState state, Buffer headerName, Buffer buffer) throws IOException {
        while (buffer.hasReadableBytes() && !state.done) {
            byte b = buffer.readByte();
            switch (b) {
                case 34: {
                    state.insideQuotedString = !state.insideQuotedString;
                    break;
                }
                case 10: {
                    state.foundCRLF = state.foundCR;
                    state.stop = buffer.getReaderIndex() - 2;
                    break;
                }
                case 13: {
                    state.foundCR = true;
                    break;
                }
                case 44: {
                    if (state.insideQuotedString || !SipParser.isHeaderAllowingMultipleValues(headerName)) break;
                    state.stop = buffer.getReaderIndex() - 1;
                    buffer.setReaderIndex(state.stop);
                    SipParser.consumeCOMMA(buffer);
                    state.foundComma = true;
                    state.foundCRLF = true;
                    break;
                }
            }
            if (!state.foundCRLF) continue;
            state.values.add(buffer.slice(state.start, state.stop));
            if (state.foldedLine) {
                Buffer line2 = state.values.remove(state.values.size() - 1);
                Buffer line1 = state.values.remove(state.values.size() - 1);
                Buffer folded = Buffers.wrap((String)(line1 + " " + line2));
                state.values.add(folded);
                state.foldedLine = false;
            }
            if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9)) {
                SipParser.consumeWS(buffer);
                state.foldedLine = !state.foundComma;
            } else if (!state.foundComma) {
                state.done = true;
            }
            state.foundCR = false;
            state.foundCRLF = false;
            state.foundComma = false;
            state.start = buffer.getReaderIndex();
        }
        return state;
    }

    public static HeaderValueState readHeaderValues(Buffer headerName, Buffer buffer) throws IOException {
        HeaderValueState state = new HeaderValueState(buffer.getReaderIndex());
        return SipParser.readHeaderValues(state, headerName, buffer);
    }

    public static SipHeader nextHeader(Buffer buffer) throws SipParseException {
        try {
            int startIndex = buffer.getReaderIndex();
            int nameIndex = 0;
            while (buffer.hasReadableBytes() && nameIndex == 0) {
                if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9) || SipParser.isNext(buffer, (byte)58)) {
                    nameIndex = buffer.getReaderIndex();
                    continue;
                }
                buffer.readByte();
            }
            if (nameIndex == 0) {
                return null;
            }
            Buffer name = buffer.slice(startIndex, nameIndex);
            SipParser.expectHCOLON(buffer);
            Buffer valueBuffer = buffer.readLine();
            if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9)) {
                ArrayList<Buffer> foldedLines = null;
                boolean done = false;
                while (!done) {
                    if (SipParser.isNext(buffer, (byte)32) || SipParser.isNext(buffer, (byte)9)) {
                        SipParser.consumeWS(buffer);
                        if (foldedLines == null) {
                            foldedLines = new ArrayList<Buffer>(2);
                        }
                        foldedLines.add(buffer.readLine());
                        continue;
                    }
                    done = true;
                }
                if (foldedLines != null) {
                    String stupid = valueBuffer.toString();
                    for (Buffer line : foldedLines) {
                        stupid = stupid + " " + line.toString();
                    }
                    valueBuffer = Buffers.wrap((byte[])stupid.getBytes(Charset.forName("UTF-8")));
                    SipParser.consumeWS(valueBuffer);
                }
            }
            return new SipHeaderImpl(name, valueBuffer);
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), UNABLE_TO_READ_FROM_STREAM, e);
        }
    }

    public static SipMessage frame(Buffer buffer) throws IOException {
        return SipParser.frame2(buffer);
    }

    public static SipMessage frame2(Buffer buffer) throws IOException {
        if (!SipParser.couldBeSipMessage(buffer)) {
            throw new SipParseException(0, "Cannot be a SIP message because is doesnt start with \"SIP\" (for responses) or a method (for requests)");
        }
        int startIndex = buffer.getReaderIndex();
        SipInitialLine initialLine = SipInitialLine.parse(buffer.readLine());
        int startHeaders = buffer.getReaderIndex();
        Buffer headerName = null;
        ArrayList<SipHeader> headers = new ArrayList<SipHeader>();
        short count = 0;
        int contentLength = 0;
        short indexOfTo = -1;
        short indexOfFrom = -1;
        short indexOfCSeq = -1;
        short indexOfCallId = -1;
        short indexOfMaxForwards = -1;
        short indexOfVia = -1;
        short indexOfRoute = -1;
        short indexOfRecordRoute = -1;
        short indexOfContact = -1;
        while (SipParser.consumeCRLF(buffer) != 2 && (headerName = SipParser.nextHeaderName(buffer)) != null) {
            List<Buffer> values = SipParser.readHeaderValues((Buffer)headerName, (Buffer)buffer).values;
            for (Buffer value : values) {
                SipHeader header = new SipHeaderImpl(headerName, value);
                if (header.isContentLengthHeader()) {
                    ContentLengthHeader l = header.ensure().toContentLengthHeader();
                    contentLength = l.getContentLength();
                    header = l;
                } else if (header.isContactHeader() && indexOfContact == -1) {
                    header = header.ensure();
                    indexOfContact = count;
                } else if (header.isCSeqHeader() && indexOfCSeq == -1) {
                    header = header.ensure();
                    indexOfCSeq = count;
                } else if (header.isMaxForwardsHeader() && indexOfMaxForwards == -1) {
                    header = header.ensure();
                    indexOfMaxForwards = count;
                } else if (header.isFromHeader() && indexOfFrom == -1) {
                    header = header.ensure();
                    indexOfFrom = count;
                } else if (header.isToHeader() && indexOfTo == -1) {
                    header = header.ensure();
                    indexOfTo = count;
                } else if (header.isViaHeader() && indexOfVia == -1) {
                    header = header.ensure();
                    indexOfVia = count;
                } else if (header.isCallIdHeader() && indexOfCallId == -1) {
                    header = header.ensure();
                    indexOfCallId = count;
                } else if (header.isRouteHeader() && indexOfRoute == -1) {
                    header = header.ensure();
                    indexOfRoute = count;
                } else if (header.isRecordRouteHeader() && indexOfRecordRoute == -1) {
                    header = header.ensure();
                    indexOfRecordRoute = count;
                }
                headers.add(header);
                count = (short)(count + 1);
            }
        }
        Buffer payload = null;
        payload = contentLength > 0 && buffer.hasReadableBytes() ? buffer.readBytes(Math.min(contentLength, buffer.getReadableBytes())) : Buffers.EMPTY_BUFFER;
        Buffer msg = buffer.slice(startIndex, buffer.getReaderIndex());
        if (initialLine.isRequestLine()) {
            return new ImmutableSipRequest(msg, initialLine.toRequestLine(), headers, indexOfTo, indexOfFrom, indexOfCSeq, indexOfCallId, indexOfMaxForwards, indexOfVia, indexOfRoute, indexOfRecordRoute, indexOfContact, payload);
        }
        return new ImmutableSipResponse(msg, initialLine.toResponseLine(), headers, indexOfTo, indexOfFrom, indexOfCSeq, indexOfCallId, indexOfMaxForwards, indexOfVia, indexOfRoute, indexOfRecordRoute, indexOfContact, payload);
    }

    public static boolean couldBeSipMessage(Buffer data) throws IOException {
        byte a = data.getByte(0);
        byte b = data.getByte(1);
        byte c = data.getByte(2);
        return SipParser.couldBeSipMessage(a, b, c);
    }

    public static boolean couldBeSipMessage(byte a, byte b, byte c) throws IOException {
        return a == 83 && b == 73 && c == 80 || a == 73 && b == 78 && c == 86 || a == 65 && b == 67 && c == 75 || a == 66 && b == 89 && c == 69 || a == 79 && b == 80 && c == 84 || a == 67 && b == 65 && c == 78 || a == 77 && b == 69 && c == 83 || a == 82 && b == 69 && c == 71 || a == 73 && b == 78 && c == 70 || a == 80 && b == 82 && c == 65 || a == 83 && b == 85 && c == 66 || a == 78 && b == 79 && c == 84 || a == 85 && b == 80 && c == 68 || a == 82 && b == 69 && c == 70 || a == 80 && b == 85 && c == 66;
    }

    static {
        framers.put(CallIdHeader.NAME, header -> CallIdHeader.frame(header.getValue()));
        framers.put(CallIdHeader.COMPACT_NAME, header -> CallIdHeader.frameCompact(header.getValue()));
        framers.put(ContactHeader.NAME, header -> ContactHeader.frame(header.getValue()));
        framers.put(ContactHeader.COMPACT_NAME, header -> ContactHeader.frame(header.getValue()));
        framers.put(ContentTypeHeader.NAME, header -> ContentTypeHeader.frame(header.getValue()));
        framers.put(ContentTypeHeader.COMPACT_NAME, header -> ContentTypeHeader.frame(header.getValue()));
        framers.put(ContentLengthHeader.NAME, header -> ContentLengthHeader.frame(header.getValue()));
        framers.put(ContentLengthHeader.COMPACT_NAME, header -> ContentLengthHeader.frame(header.getValue()));
        framers.put(CSeqHeader.NAME, header -> CSeqHeader.frame(header.getValue()));
        framers.put(ExpiresHeader.NAME, header -> ExpiresHeader.frame(header.getValue()));
        framers.put(FromHeader.NAME, header -> FromHeader.frame(header.getValue()));
        framers.put(FromHeader.COMPACT_NAME, header -> FromHeader.frame(header.getValue()));
        framers.put(MaxForwardsHeader.NAME, header -> MaxForwardsHeader.frame(header.getValue()));
        framers.put(RecordRouteHeader.NAME, header -> RecordRouteHeader.frame(header.getValue()));
        framers.put(RouteHeader.NAME, header -> RouteHeader.frame(header.getValue()));
        framers.put(ToHeader.NAME, header -> ToHeader.frame(header.getValue()));
        framers.put(ToHeader.COMPACT_NAME, header -> ToHeader.frame(header.getValue()));
        framers.put(ViaHeader.NAME, header -> ViaHeader.frame(header.getValue()));
        framers.put(ViaHeader.COMPACT_NAME, header -> ViaHeader.frame(header.getValue()));
    }

    public static final class HeaderValueState {
        public List<Buffer> values = new ArrayList<Buffer>(2);
        public int start;
        public int stop = -1;
        public boolean foundCR = false;
        public boolean foundCRLF = false;
        public boolean foundComma = false;
        public boolean insideQuotedString = false;
        public boolean done = false;
        public boolean foldedLine = false;

        public HeaderValueState(int readerIndex) {
            this.start = readerIndex;
        }

        public void reset(int readerIndex) {
            this.start = readerIndex;
            this.values = new ArrayList<Buffer>(2);
            this.stop = -1;
            this.foundCR = false;
            this.foundCRLF = false;
            this.foundComma = false;
            this.insideQuotedString = false;
            this.done = false;
            this.foldedLine = false;
        }
    }
}

