/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.Address;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.header.impl.RecordRouteHeaderImpl;

public interface RecordRouteHeader
extends AddressParametersHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Record-Route");

    @Override
    public RecordRouteHeader clone();

    public static RecordRouteHeader frame(Buffer buffer) throws SipParseException {
        Buffer original = buffer.slice();
        Object[] result = AddressParametersHeader.frame(buffer);
        return new RecordRouteHeaderImpl(original, (Address)result[0], (Buffer)result[1]);
    }

    @Override
    public Builder copy();

    @Override
    default public boolean isRecordRouteHeader() {
        return true;
    }

    @Override
    default public RecordRouteHeader toRecordRouteHeader() {
        return this;
    }

    public static Builder withUser(Buffer user) {
        Builder b = new Builder();
        b.withUser(user);
        return b;
    }

    public static Builder withUser(String user) {
        return RecordRouteHeader.withUser(Buffers.wrap((String)user));
    }

    public static Builder withHost(Buffer host) {
        Builder b = new Builder();
        b.withHost(host);
        return b;
    }

    public static Builder withHost(String host) {
        return RecordRouteHeader.withHost(Buffers.wrap((String)host));
    }

    public static Builder withAddress(Address address) throws SipParseException {
        Builder builder = new Builder();
        builder.withAddress(address);
        return builder;
    }

    public static class Builder
    extends AddressParametersHeader.Builder<RecordRouteHeader> {
        private Builder(ParametersSupport params) {
            super(NAME, params);
        }

        private Builder() {
            super(NAME);
        }

        @Override
        public RecordRouteHeader internalBuild(Buffer rawValue, Address address, Buffer params) throws SipParseException {
            return new RecordRouteHeaderImpl(rawValue, address, params);
        }
    }
}

