/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeJvmKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.FileChannelsKt;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/http/content/LocalFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "file", "Ljava/io/File;", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/io/File;Lio/ktor/http/ContentType;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "getFile", "()Ljava/io/File;", "readFrom", "Lio/ktor/utils/io/ByteReadChannel;", "range", "Lkotlin/ranges/LongRange;", "ktor-server-core"})
public final class LocalFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final File file;
    @NotNull
    private final ContentType contentType;

    public LocalFileContent(@NotNull File file2, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.file = file2;
        this.contentType = contentType;
        long lastModifiedVersion = this.file.lastModified();
        if (lastModifiedVersion == 0L) {
            throw new IOException("No such file " + this.file.getAbsolutePath());
        }
        VersionsKt.setVersions((OutgoingContent)((OutgoingContent)this), (List)CollectionsKt.plus((Collection)VersionsKt.getVersions((OutgoingContent)((OutgoingContent)this)), (Object)LastModifiedJavaTimeKt.LastModifiedVersion(lastModifiedVersion)));
    }

    public /* synthetic */ LocalFileContent(File file2, ContentType contentType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            contentType = FileContentTypeJvmKt.defaultForFile((ContentType.Companion)ContentType.Companion, (File)file2);
        }
        this(file2, contentType);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @NotNull
    public Long getContentLength() {
        return this.file.length();
    }

    @NotNull
    public ByteReadChannel readFrom() {
        return FileChannelsKt.readChannel$default((File)this.file, (long)0L, (long)0L, null, (int)7, null);
    }

    @NotNull
    public ByteReadChannel readFrom(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return FileChannelsKt.readChannel$default((File)this.file, (long)range.getStart(), (long)range.getEndInclusive(), null, (int)4, null);
    }
}

