/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.UninitializedMessageException;
import org.sonatype.spice.zapper.internal.hawtbuf.FileBase;
import org.sonatype.spice.zapper.internal.hawtbuf.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class File
extends FileBase<File> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasFileId()) {
            missingFields.add("fileId");
        }
        if (!this.hasPath()) {
            missingFields.add("path");
        }
        if (!this.hasFileLastModified()) {
            missingFields.add("fileLastModified");
        }
        if (this.hasHashes()) {
            List l = this.getHashesList();
            for (int i = 0; i < l.size(); ++i) {
                try {
                    ((Hash)((Object)l.get(i))).assertInitialized();
                    continue;
                }
                catch (UninitializedMessageException e) {
                    missingFields.addAll(this.prefix(e.getMissingFields(), "hashes[" + i + "]"));
                }
            }
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearFileId();
        this.clearPath();
        this.clearFileLastModified();
        this.clearHashes();
        this.clearFilters();
    }

    public File clone() {
        return new File().mergeFrom(this);
    }

    public File mergeFrom(File other) {
        if (other.hasFileId()) {
            this.setFileId(other.getFileId());
        }
        if (other.hasPath()) {
            this.setPath(other.getPath());
        }
        if (other.hasFileLastModified()) {
            this.setFileLastModified(other.getFileLastModified());
        }
        if (other.hasHashes()) {
            for (Hash element : other.getHashesList()) {
                this.getHashesList().add(element.clone());
            }
        }
        if (other.hasFilters()) {
            this.getFiltersList().addAll(other.getFiltersList());
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasFileId()) {
            size += CodedOutputStream.computeStringSize((int)1, (String)this.getFileId());
        }
        if (this.hasPath()) {
            size += CodedOutputStream.computeStringSize((int)2, (String)this.getPath());
        }
        if (this.hasFileLastModified()) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.getFileLastModified());
        }
        if (this.hasHashes()) {
            for (Object i : this.getHashesList()) {
                size += File.computeMessageSize((int)4, (BaseMessage)i);
            }
        }
        if (this.hasFilters()) {
            for (Object i : this.getFiltersList()) {
                size += CodedOutputStream.computeStringSize((int)5, (String)i);
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public File mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block8: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block8;
                }
                case 10: {
                    this.setFileId(input.readString());
                    continue block8;
                }
                case 18: {
                    this.setPath(input.readString());
                    continue block8;
                }
                case 24: {
                    this.setFileLastModified(input.readInt64());
                    continue block8;
                }
                case 34: {
                    this.getHashesList().add(new Hash().mergeFramed(input));
                    continue block8;
                }
                case 42: 
            }
            this.getFiltersList().add(input.readString());
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasFileId()) {
            output.writeString(1, this.getFileId());
        }
        if (this.hasPath()) {
            output.writeString(2, this.getPath());
        }
        if (this.hasFileLastModified()) {
            output.writeInt64(3, this.getFileLastModified());
        }
        if (this.hasHashes()) {
            for (Object i : this.getHashesList()) {
                File.writeMessage((CodedOutputStream)output, (int)4, (BaseMessage)i);
            }
        }
        if (this.hasFilters()) {
            for (Object i : this.getFiltersList()) {
                output.writeString(5, (String)i);
            }
        }
    }

    public static File parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (File)((Object)new File().mergeUnframed(data).checktInitialized());
    }

    public static File parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (File)((Object)((File)((Object)new File().mergeUnframed(data))).checktInitialized());
    }

    public static File parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (File)((Object)((File)((Object)new File().mergeUnframed(data))).checktInitialized());
    }

    public static File parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (File)((Object)((File)((Object)new File().mergeUnframed(data))).checktInitialized());
    }

    public static File parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (File)((Object)((File)((Object)new File().mergeFramed(data))).checktInitialized());
    }

    public static File parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (File)((Object)((File)((Object)new File().mergeFramed(data))).checktInitialized());
    }

    public static File parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (File)((Object)((File)((Object)new File().mergeFramed(data))).checktInitialized());
    }

    public static File parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (File)((Object)((File)((Object)new File().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        int i;
        List l;
        if (this.hasFileId()) {
            sb.append(prefix + "fileId: ");
            sb.append(this.getFileId());
            sb.append("\n");
        }
        if (this.hasPath()) {
            sb.append(prefix + "path: ");
            sb.append(this.getPath());
            sb.append("\n");
        }
        if (this.hasFileLastModified()) {
            sb.append(prefix + "fileLastModified: ");
            sb.append(this.getFileLastModified());
            sb.append("\n");
        }
        if (this.hasHashes()) {
            l = this.getHashesList();
            for (i = 0; i < l.size(); ++i) {
                sb.append(prefix + "hashes[" + i + "] {\n");
                ((Hash)((Object)l.get(i))).toString(sb, prefix + "  ");
                sb.append(prefix + "}\n");
            }
        }
        if (this.hasFilters()) {
            l = this.getFiltersList();
            for (i = 0; i < l.size(); ++i) {
                sb.append(prefix + "filters[" + i + "]: ");
                sb.append((String)l.get(i));
                sb.append("\n");
            }
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != File.class) {
            return false;
        }
        return this.equals((File)((Object)obj));
    }

    public boolean equals(File obj) {
        if (this.hasFileId() ^ obj.hasFileId()) {
            return false;
        }
        if (this.hasFileId() && !this.getFileId().equals(obj.getFileId())) {
            return false;
        }
        if (this.hasPath() ^ obj.hasPath()) {
            return false;
        }
        if (this.hasPath() && !this.getPath().equals(obj.getPath())) {
            return false;
        }
        if (this.hasFileLastModified() ^ obj.hasFileLastModified()) {
            return false;
        }
        if (this.hasFileLastModified() && this.getFileLastModified() != obj.getFileLastModified()) {
            return false;
        }
        if (this.hasHashes() ^ obj.hasHashes()) {
            return false;
        }
        if (this.hasHashes() && !this.getHashesList().equals(obj.getHashesList())) {
            return false;
        }
        if (this.hasFilters() ^ obj.hasFilters()) {
            return false;
        }
        return !this.hasFilters() || this.getFiltersList().equals(obj.getFiltersList());
    }

    public int hashCode() {
        int rc = 2189724;
        if (this.hasFileId()) {
            rc ^= 0x7D6D7BD7 ^ this.getFileId().hashCode();
        }
        if (this.hasPath()) {
            rc ^= 0x25D845 ^ this.getPath().hashCode();
        }
        if (this.hasFileLastModified()) {
            rc ^= 0x6AB3373B ^ new Long(this.getFileLastModified()).hashCode();
        }
        if (this.hasHashes()) {
            rc ^= 0x8069AE5C ^ this.getHashesList().hashCode();
        }
        if (this.hasFilters()) {
            rc ^= 0x30493BDB ^ this.getFiltersList().hashCode();
        }
        return rc;
    }
}

