/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core.internal;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.internal.BaselineSupportKt;
import com.pinterest.ktlint.core.internal.CurrentBaseline;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0016\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"logger", "Lmu/KLogger;", "relativeRoute", "", "Ljava/io/File;", "getRelativeRoute", "(Ljava/io/File;)Ljava/lang/String;", "loadBaseline", "Lcom/pinterest/ktlint/core/internal/CurrentBaseline;", "baselineFilePath", "parseBaseline", "", "", "Lcom/pinterest/ktlint/core/LintError;", "baselineFile", "Ljava/io/InputStream;", "parseBaselineErrorsByFile", "", "element", "Lorg/w3c/dom/Element;", "containsLintError", "", "error", "ktlint-core"})
public final class BaselineSupportKt {
    @NotNull
    private static final KLogger logger = KtLintKLoggerInitializerKt.initKtLintKLogger(KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE));

    @NotNull
    public static final CurrentBaseline loadBaseline(@NotNull String baselineFilePath) {
        Intrinsics.checkNotNullParameter((Object)baselineFilePath, (String)"baselineFilePath");
        if (StringsKt.isBlank((CharSequence)baselineFilePath)) {
            return new CurrentBaseline(null, false);
        }
        Map<String, List<LintError>> baselineRules = null;
        boolean baselineGenerationNeeded = true;
        File baselineFile = Paths.get(baselineFilePath, new String[0]).toFile();
        if (baselineFile.exists()) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)baselineFile, (String)"baselineFile");
                baselineRules = BaselineSupportKt.parseBaseline(new FileInputStream(baselineFile));
                baselineGenerationNeeded = false;
            }
            catch (IOException e) {
                logger.error((Function0)new Function0<Object>(baselineFilePath){
                    final /* synthetic */ String $baselineFilePath;
                    {
                        this.$baselineFilePath = $baselineFilePath;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$baselineFilePath;
                    }
                });
                baselineGenerationNeeded = true;
            }
            catch (ParserConfigurationException e) {
                logger.error((Function0)new Function0<Object>(baselineFilePath){
                    final /* synthetic */ String $baselineFilePath;
                    {
                        this.$baselineFilePath = $baselineFilePath;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$baselineFilePath;
                    }
                });
                baselineGenerationNeeded = true;
            }
            catch (SAXException e) {
                logger.error((Function0)new Function0<Object>(baselineFilePath){
                    final /* synthetic */ String $baselineFilePath;
                    {
                        this.$baselineFilePath = $baselineFilePath;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$baselineFilePath;
                    }
                });
                baselineGenerationNeeded = true;
            }
        }
        if (baselineGenerationNeeded && baselineFile.exists()) {
            baselineFile.delete();
        }
        return new CurrentBaseline(baselineRules, baselineGenerationNeeded);
    }

    @NotNull
    public static final Map<String, List<LintError>> parseBaseline(@NotNull InputStream baselineFile) {
        Intrinsics.checkNotNullParameter((Object)baselineFile, (String)"baselineFile");
        HashMap baselineRules = new HashMap();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(baselineFile);
        NodeList filesList = doc.getElementsByTagName("file");
        int n = filesList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = filesList.item(i);
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element fileElement = (Element)node;
            String fileName = fileElement.getAttribute("name");
            List<LintError> baselineErrors = BaselineSupportKt.parseBaselineErrorsByFile(fileElement);
            Map map = baselineRules;
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            map.put(fileName, baselineErrors);
        }
        return baselineRules;
    }

    private static final List<LintError> parseBaselineErrorsByFile(Element element) {
        List errors = new ArrayList();
        NodeList errorsList = element.getElementsByTagName("error");
        int n = errorsList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = errorsList.item(i);
            if (node == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element errorElement = (Element)node;
            String string = errorElement.getAttribute("line");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorElement.getAttribute(\"line\")");
            int n2 = Integer.parseInt(string);
            String string2 = errorElement.getAttribute("column");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorElement.getAttribute(\"column\")");
            int n3 = Integer.parseInt(string2);
            String string3 = errorElement.getAttribute("source");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"errorElement.getAttribute(\"source\")");
            errors.add(new LintError(n2, n3, string3, ""));
        }
        return errors;
    }

    public static final boolean containsLintError(@NotNull List<LintError> $this$containsLintError, @NotNull LintError error) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$containsLintError, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Iterable $this$firstOrNull$iv = $this$containsLintError;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LintError lintError = (LintError)element$iv;
                boolean bl = false;
                boolean bl2 = lintError.getCol() == error.getCol() && lintError.getLine() == error.getLine() && Intrinsics.areEqual((Object)lintError.getRuleId(), (Object)error.getRuleId());
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }

    @NotNull
    public static final String getRelativeRoute(@NotNull File $this$relativeRoute) {
        Intrinsics.checkNotNullParameter((Object)$this$relativeRoute, (String)"<this>");
        Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
        Path filePath = $this$relativeRoute.toPath();
        return StringsKt.replace$default((String)((Object)rootPath.relativize(filePath)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }
}

