/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/github/ajalt/colormath/XYZ;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "x", "", "y", "z", "(DDD)V", "getX", "()D", "getY", "getZ", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toLAB", "Lcom/github/ajalt/colormath/LAB;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colorconversion"})
public final class XYZ
implements ConvertibleColor {
    private final double x;
    private final double y;
    private final double z;

    @Override
    @NotNull
    public RGB toRGB() {
        double x = this.x / (double)100;
        double y = this.y / (double)100;
        double z = this.z / (double)100;
        toRGB.1 adj$ = toRGB.1.INSTANCE;
        double r = 3.2404542 * x - 1.5371385 * y - 0.4985314 * z;
        double g = -0.969266 * x + 1.8760108 * y + 0.041556 * z;
        double b = 0.0556434 * x - 0.2040259 * y + 1.0572252 * z;
        return new RGB(adj$.invoke(r), adj$.invoke(g), adj$.invoke(b));
    }

    @Override
    @NotNull
    public LAB toLAB() {
        toLAB.1 f$ = toLAB.1.INSTANCE;
        double fx = f$.invoke(this.x / 95.047);
        double fy = f$.invoke(this.y / 100.0);
        double fz = f$.invoke(this.z / 108.883);
        double l = (double)116 * fy - (double)16;
        double a = (double)500 * (fx - fy);
        double b = (double)200 * (fy - fz);
        return new LAB(l, a, b);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public XYZ(double x, double y, double z) {
        boolean bl;
        this.x = x;
        this.y = y;
        this.z = z;
        boolean bl2 = bl = this.x >= 0.0;
        if (!bl) {
            String string = "x must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = this.y >= 0.0;
        if (!bl) {
            String string = "y must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = this.z >= 0.0;
        if (!bl) {
            String string = "z must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return ConvertibleColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return ConvertibleColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return ConvertibleColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return ConvertibleColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final XYZ copy(double x, double y, double z) {
        return new XYZ(x, y, z);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ XYZ copy$default(XYZ xYZ, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = xYZ.x;
        }
        if ((n & 2) != 0) {
            d2 = xYZ.y;
        }
        if ((n & 4) != 0) {
            d3 = xYZ.z;
        }
        return xYZ.copy(d, d2, d3);
    }

    public String toString() {
        return "XYZ(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        return ((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof XYZ)) break block3;
                XYZ xYZ = (XYZ)object;
                if (Double.compare(this.x, xYZ.x) != 0 || Double.compare(this.y, xYZ.y) != 0 || Double.compare(this.z, xYZ.z) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

