/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.mojo.exec.ExecutableDependency;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractExecMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private MavenProjectBuilder projectBuilder;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;
    @Parameter
    protected ExecutableDependency executableDependency;
    @Parameter(property="sourceRoot")
    private File sourceRoot;
    @Parameter(property="testSourceRoot")
    private File testSourceRoot;
    @Parameter(property="exec.args")
    private String commandlineArgs;
    @Parameter(property="exec.classpathScope", defaultValue="runtime")
    protected String classpathScope;
    @Parameter(property="exec.skip", defaultValue="false", alias="skip")
    private boolean skip;
    @Parameter(property="addResourcesToClasspath", defaultValue="false")
    private boolean addResourcesToClasspath;
    @Parameter(property="addOutputToClasspath", defaultValue="true")
    private boolean addOutputToClasspath;

    protected void collectProjectArtifactsAndClasspath(List<Artifact> artifacts, List<File> theClasspathFiles) {
        if (this.addResourcesToClasspath) {
            for (Resource r : this.project.getBuild().getResources()) {
                theClasspathFiles.add(new File(r.getDirectory()));
            }
        }
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
            }
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(new File(this.project.getBuild().getTestOutputDirectory()));
                theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
            }
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
            }
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug((CharSequence)("Collected project artifacts " + artifacts));
        this.getLog().debug((CharSequence)("Collected project classpath " + theClasspathFiles));
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.commandlineArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        for (Artifact pluginDep : this.pluginDependencies) {
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }
}

