/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToOutputFilesMap;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0014\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/build/report/ICReporter;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$incremental_compilation_impl", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToOutputFilesMap;", "registerOutputForSourceFiles", "", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "removeOutputForSourceFiles", "sources", "", "Companion", "incremental-compilation-impl"})
public final class InputsCache
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    @NotNull
    private final SourceToOutputFilesMap sourceToOutputMap;

    public InputsCache(@NotNull File workingDir, @NotNull ICReporter reporter, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(workingDir);
        this.reporter = reporter;
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile("source-snapshot"), pathConverter));
        this.sourceToOutputMap = (SourceToOutputFilesMap)this.registerMap((BasicMap)new SourceToOutputFilesMap(this.getStorageFile("source-to-output"), pathConverter));
    }

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$incremental_compilation_impl() {
        return this.sourceSnapshotMap;
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        for (File file2 : sources) {
            Iterable $this$forEach$iv = this.sourceToOutputMap.remove(file2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.reporter.reportVerbose((Function0<String>)((Function0)new Function0<String>(it, file2){
                    final /* synthetic */ File $it;
                    final /* synthetic */ File $sourceFile;
                    {
                        this.$it = $it;
                        this.$sourceFile = $sourceFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Deleting " + this.$it + " on clearing cache for " + this.$sourceFile;
                    }
                }));
                it.delete();
            }
        }
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        MultiMap<File, File> sourceToOutput = new MultiMap<File, File>();
        for (GeneratedFile entry : generatedFiles) {
            for (File source : entry.getSourceFiles()) {
                sourceToOutput.putValue(source, entry.getOutputFile());
            }
        }
        for (Map.Entry entry : sourceToOutput.entrySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"sourceToOutput.entrySet()");
            File source = (File)entry.getKey();
            Collection outputs = (Collection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            Intrinsics.checkNotNullExpressionValue((Object)outputs, (String)"outputs");
            this.sourceToOutputMap.set(source, outputs);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache$Companion;", "", "()V", "SOURCE_SNAPSHOTS", "", "SOURCE_TO_OUTPUT_FILES", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

