/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.IPPacket;
import io.pkts.packet.TCPPacket;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.TransportPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class TcpPacketImpl
extends TransportPacketImpl
implements TCPPacket {
    private final Buffer headers;
    private final Buffer options;

    public TcpPacketImpl(IPPacket parent, Buffer headers, Buffer options, Buffer payload) {
        super(parent, Protocol.TCP, headers, payload);
        this.headers = headers;
        this.options = options;
    }

    @Override
    public boolean isTCP() {
        return true;
    }

    @Override
    public int getHeaderLength() {
        return 20 + (this.options != null ? this.options.capacity() : 0);
    }

    @Override
    public boolean isFIN() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 1) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSYN() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 2) == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isRST() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 4) == 4;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isPSH() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 8) == 8;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isACK() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 0x10) == 16;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isURG() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 0x20) == 32;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isECE() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 0x40) == 64;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isCWR() {
        try {
            byte b = this.headers.getByte(13);
            return (b & 0x80) == 128;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getSequenceNumber() {
        return this.headers.slice(4, 8).readUnsignedInt();
    }

    @Override
    public long getAcknowledgementNumber() {
        return this.headers.slice(8, 12).readUnsignedInt();
    }

    @Override
    public TransportPacket clone() {
        IPPacket parent = this.getParentPacket().clone();
        Buffer options = this.options != null ? this.options.clone() : null;
        return new TcpPacketImpl(parent, this.headers.clone(), options, this.getPayload().clone());
    }

    @Override
    public final void write(OutputStream out, Buffer payload) throws IOException {
        this.getParentPacket().write(out, Buffers.wrap((Buffer)this.headers, (Buffer)payload));
    }
}

