/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/servlet/ServletConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "servletRequest", "Ljavax/servlet/http/HttpServletRequest;", "(Ljavax/servlet/http/HttpServletRequest;)V", "host", "", "getHost", "()Ljava/lang/String;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "port", "", "getPort", "()I", "remoteHost", "getRemoteHost", "scheme", "getScheme", "uri", "getUri", "version", "getVersion", "ktor-server-servlet"})
public final class ServletConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final String uri;
    @NotNull
    private final String version;
    @NotNull
    private final HttpMethod method;
    @NotNull
    private final String scheme;
    private final int port;
    @NotNull
    private final String host;
    @NotNull
    private final String remoteHost;

    /*
     * WARNING - void declaration
     */
    public ServletConnectionPoint(@NotNull HttpServletRequest servletRequest) {
        String string;
        void query;
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        String string2 = servletRequest.getQueryString();
        ServletConnectionPoint servletConnectionPoint = this;
        boolean bl = false;
        if (query == null) {
            String string3 = servletRequest.getRequestURI();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            string = servletRequest.getRequestURI() + '?' + (String)query;
        }
        servletConnectionPoint.uri = string;
        String string4 = servletRequest.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"servletRequest.protocol");
        this.version = string4;
        String string5 = servletRequest.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"servletRequest.method");
        this.method = HttpMethod.Companion.parse(string5);
        String string6 = servletRequest.getScheme();
        if (string6 == null) {
            string6 = "http";
        }
        this.scheme = string6;
        this.port = servletRequest.getServerPort();
        String string7 = servletRequest.getServerName();
        if (string7 == null) {
            string7 = "localhost";
        }
        this.host = string7;
        String string8 = servletRequest.getRemoteHost();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"servletRequest.remoteHost");
        this.remoteHost = string8;
    }

    @NotNull
    public String getUri() {
        return this.uri;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NotNull
    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    @NotNull
    public String getRemoteHost() {
        return this.remoteHost;
    }
}

