/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.index;

import java.util.Stack;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.util.HtmlTools;

public class IndexingSink
extends SinkAdapter {
    private static final int TYPE_SECTION_1 = 1;
    private static final int TYPE_SECTION_2 = 2;
    private static final int TYPE_SECTION_3 = 3;
    private static final int TYPE_SECTION_4 = 4;
    private static final int TYPE_SECTION_5 = 5;
    private static final int TYPE_DEFINED_TERM = 6;
    private static final int TYPE_FIGURE = 7;
    private static final int TYPE_TABLE = 8;
    private static final int TITLE = 9;
    private int type;
    private String title;
    private final Stack<IndexEntry> stack = new Stack();

    public IndexingSink(IndexEntry sectionEntry) {
        this.stack.push(sectionEntry);
        this.init();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void title() {
        this.type = 9;
    }

    @Override
    public void section1() {
        this.pushNewEntry();
    }

    @Override
    public void sectionTitle1() {
        this.type = 1;
    }

    @Override
    public void title_() {
        this.type = 0;
    }

    @Override
    public void sectionTitle1_() {
        this.type = 0;
    }

    @Override
    public void section1_() {
        this.pop();
    }

    @Override
    public void section2() {
        this.pushNewEntry();
    }

    @Override
    public void sectionTitle2() {
        this.type = 2;
    }

    @Override
    public void sectionTitle2_() {
        this.type = 0;
    }

    @Override
    public void section2_() {
        this.pop();
    }

    @Override
    public void section3() {
        this.pushNewEntry();
    }

    @Override
    public void sectionTitle3() {
        this.type = 3;
    }

    @Override
    public void sectionTitle3_() {
        this.type = 0;
    }

    @Override
    public void section3_() {
        this.pop();
    }

    @Override
    public void section4() {
        this.pushNewEntry();
    }

    @Override
    public void sectionTitle4() {
        this.type = 4;
    }

    @Override
    public void sectionTitle4_() {
        this.type = 0;
    }

    @Override
    public void section4_() {
        this.pop();
    }

    @Override
    public void section5() {
        this.pushNewEntry();
    }

    @Override
    public void sectionTitle5() {
        this.type = 5;
    }

    @Override
    public void sectionTitle5_() {
        this.type = 0;
    }

    @Override
    public void section5_() {
        this.pop();
    }

    @Override
    public void text(String text) {
        switch (this.type) {
            case 9: {
                this.title = text;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                IndexEntry entry = (IndexEntry)this.stack.lastElement();
                String title = entry.getTitle() + text;
                title = title.replaceAll("[\\r\\n]+", "");
                entry.setTitle(title);
                entry.setId(HtmlTools.encodeId(title));
                break;
            }
        }
    }

    public void pushNewEntry() {
        IndexEntry entry = new IndexEntry(this.peek(), "");
        entry.setTitle("");
        this.stack.push(entry);
    }

    public void push(IndexEntry entry) {
        this.stack.push(entry);
    }

    public void pop() {
        this.stack.pop();
    }

    public IndexEntry peek() {
        return this.stack.peek();
    }

    @Override
    public void close() {
        super.close();
        this.init();
    }

    @Override
    protected void init() {
        this.type = 0;
        this.title = null;
    }
}

