/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="org.sonatype.nexus.maven.staging.deploy.DeployLifecycleParticipant")
public class DeployLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    public static String _THIS_GROUP_ID = "org.sonatype.plugins";
    public static String _THIS_ARTIFACT_ID = "nexus-staging-maven-plugin";
    public static String MAVEN_DEPLOY_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    public static String MAVEN_DEPLOY_PLUGIN_ARTIFACT_ID = "maven-deploy-plugin";
    private Logger logger;

    protected String getPluginGroupId() {
        return _THIS_GROUP_ID;
    }

    protected String getPluginArtifactId() {
        return _THIS_ARTIFACT_ID;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            int totalModules = session.getProjects().size();
            this.logger.info("Inspecting build with total of " + totalModules + " modules...");
            int stagingGoalsFoundInModules = 0;
            block2: for (MavenProject project : session.getProjects()) {
                Plugin nexusMavenPlugin = this.getBuildPluginsNexusMavenPlugin(project.getModel());
                if (nexusMavenPlugin == null || nexusMavenPlugin.getExecutions().isEmpty()) continue;
                for (PluginExecution pluginExecution : nexusMavenPlugin.getExecutions()) {
                    List goals = pluginExecution.getGoals();
                    if (!goals.contains("deploy") && !goals.contains("deploy-staged") && !goals.contains("staging-close") && !goals.contains("staging-release") && !goals.contains("staging-promote")) continue;
                    ++stagingGoalsFoundInModules;
                    continue block2;
                }
            }
            if (stagingGoalsFoundInModules > 0) {
                this.logger.info("Not installing Nexus Staging features:");
                if (stagingGoalsFoundInModules > 0) {
                    this.logger.info(" * Preexisting staging related goal bindings found in " + stagingGoalsFoundInModules + " modules.");
                }
                return;
            }
            this.logger.info("Installing Nexus Staging features:");
            int skipped = 0;
            for (MavenProject project : session.getProjects()) {
                Plugin mavenDeployPlugin;
                Plugin nexusMavenPlugin = this.getBuildPluginsNexusMavenPlugin(project.getModel());
                if (nexusMavenPlugin == null || (mavenDeployPlugin = this.getBuildPluginsMavenDeployPlugin(project.getModel())) == null) continue;
                mavenDeployPlugin.getExecutions().clear();
                PluginExecution execution = new PluginExecution();
                execution.setId("injected-nexus-deploy");
                execution.getGoals().add("deploy");
                execution.setPhase("deploy");
                execution.setConfiguration(nexusMavenPlugin.getConfiguration());
                nexusMavenPlugin.getExecutions().add(execution);
                ++skipped;
            }
            if (skipped > 0) {
                this.logger.info("  ... total of " + skipped + " executions of maven-deploy-plugin replaced with " + this.getPluginArtifactId());
            }
        }
        catch (IllegalStateException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected Plugin getBuildPluginsNexusMavenPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getNexusMavenPluginFromContainer((PluginContainer)model.getBuild());
        }
        return null;
    }

    protected Plugin getBuildPluginsMavenDeployPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getMavenDeployPluginFromContainer((PluginContainer)model.getBuild());
        }
        return null;
    }

    protected Plugin getNexusMavenPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(this.getPluginGroupId(), this.getPluginArtifactId(), pluginContainer);
    }

    protected Plugin getMavenDeployPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(MAVEN_DEPLOY_PLUGIN_GROUP_ID, MAVEN_DEPLOY_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected void setPluginScalarConfigurationValueEverywhere(String key, String value, boolean override, Plugin plugin) {
        this.setPluginScalarConfigurationValueInAllExecutions(key, value, override, plugin);
        Xpp3Dom pluginConfiguration = this.setPluginScalarConfigurationValue(key, value, override, (Xpp3Dom)plugin.getConfiguration());
        plugin.setConfiguration((Object)pluginConfiguration);
    }

    protected void setPluginScalarConfigurationValueInAllExecutions(String key, String value, boolean override, Plugin plugin) {
        for (PluginExecution execution : plugin.getExecutions()) {
            Xpp3Dom executionConfiguration = this.setPluginScalarConfigurationValue(key, value, override, (Xpp3Dom)execution.getConfiguration());
            execution.setConfiguration((Object)executionConfiguration);
        }
    }

    protected Xpp3Dom setPluginScalarConfigurationValue(String key, String value, boolean override, Xpp3Dom originalConfiguration) {
        Xpp3Dom changed;
        Xpp3Dom configuration = originalConfiguration;
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
        }
        if ((changed = configuration.getChild(key)) != null && !override) {
            return originalConfiguration;
        }
        if (changed == null) {
            changed = new Xpp3Dom(key);
            configuration.addChild(changed);
        }
        changed.setValue(value);
        return configuration;
    }

    protected Plugin getPluginByGAFromContainer(String groupId, String artifactId, PluginContainer pluginContainer) {
        Plugin result = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            if (!Strings.nullToEmpty((String)groupId).equals(Strings.nullToEmpty((String)plugin.getGroupId())) || !Strings.nullToEmpty((String)artifactId).equals(Strings.nullToEmpty((String)plugin.getArtifactId()))) continue;
            if (result != null) {
                throw new IllegalStateException("The build contains multiple versions of plugin " + groupId + ":" + artifactId);
            }
            result = plugin;
        }
        return result;
    }
}

