/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability;

import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.usability.diagnostics.DiagnosisUtils;
import org.apache.maven.usability.diagnostics.ErrorDiagnoser;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class ProfileActivationDiagnoser
implements ErrorDiagnoser {
    public boolean canDiagnose(Throwable error) {
        return DiagnosisUtils.containsInCausality((Throwable)error, ProfileActivationException.class);
    }

    public String diagnose(Throwable error) {
        ProfileActivationException activationException = (ProfileActivationException)DiagnosisUtils.getFromCausality((Throwable)error, ProfileActivationException.class);
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("Error activating profiles.");
        messageBuffer.append("\n\nReason: ").append(activationException.getMessage());
        if (DiagnosisUtils.containsInCausality((Throwable)activationException, ComponentLookupException.class)) {
            ComponentLookupException cle = (ComponentLookupException)DiagnosisUtils.getFromCausality((Throwable)activationException, ComponentLookupException.class);
            messageBuffer.append("\n\nThere was a problem retrieving one or more profile activators.");
            messageBuffer.append("\n").append(cle.getMessage());
        }
        messageBuffer.append("\n");
        return messageBuffer.toString();
    }
}

