/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV6NeighborDiscoveryPrefixInformationOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = -1397830548673996516L;
    private static final int TYPE_OFFSET = 0;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_OFFSET = 1;
    private static final int LENGTH_SIZE = 1;
    private static final int PREFIX_LENGTH_OFFSET = 2;
    private static final int PREFIX_LENGTH_SIZE = 1;
    private static final int L_A_RESERVED1_OFFSET = 3;
    private static final int L_A_RESERVED1_SIZE = 1;
    private static final int VALID_LIFETIME_OFFSET = 4;
    private static final int VALID_LIFETIME_SIZE = 4;
    private static final int PREFERRED_LIFETIME_OFFSET = 8;
    private static final int PREFERRED_LIFETIME_SIZE = 4;
    private static final int RESERVED2_OFFSET = 12;
    private static final int RESERVED2_SIZE = 4;
    private static final int PREFIX_OFFSET = 16;
    private static final int PREFIX_SIZE = 16;
    private static final int IPV6_NEIGHBOR_DISCOVERY_PREFIX_INFORMATION_OPTION_SIZE = 32;
    private final IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.PREFIX_INFORMATION;
    private final byte length;
    private final byte prefixLength;
    private final boolean onLinkFlag;
    private final boolean addressConfigurationFlag;
    private final byte reserved1;
    private final int validLifetime;
    private final int preferredLifetime;
    private final int reserved2;
    private final Inet6Address prefix;

    public static IpV6NeighborDiscoveryPrefixInformationOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6NeighborDiscoveryPrefixInformationOption(rawData, offset, length);
    }

    private IpV6NeighborDiscoveryPrefixInformationOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 32) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 31. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        int lengthFieldAsInt = this.getLengthAsInt();
        if (lengthFieldAsInt * 8 != 32) {
            throw new IllegalRawDataException("Invalid value of length field: " + lengthFieldAsInt);
        }
        this.prefixLength = ByteArrays.getByte(rawData, 2 + offset);
        byte tmp = ByteArrays.getByte(rawData, 3 + offset);
        this.onLinkFlag = (tmp & 0x80) != 0;
        this.addressConfigurationFlag = (tmp & 0x40) != 0;
        this.reserved1 = (byte)(0x3F & tmp);
        this.validLifetime = ByteArrays.getInt(rawData, 4 + offset);
        this.preferredLifetime = ByteArrays.getInt(rawData, 8 + offset);
        this.reserved2 = ByteArrays.getInt(rawData, 12 + offset);
        this.prefix = ByteArrays.getInet6Address(rawData, 16 + offset);
    }

    private IpV6NeighborDiscoveryPrefixInformationOption(Builder builder) {
        if (builder == null || builder.prefix == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.prefix: ").append(builder.prefix);
            throw new NullPointerException(sb.toString());
        }
        if ((builder.reserved1 & 0xC0) != 0) {
            throw new IllegalArgumentException("Invalid reserved1: " + builder.reserved1);
        }
        this.prefixLength = builder.prefixLength;
        this.onLinkFlag = builder.onLinkFlag;
        this.addressConfigurationFlag = builder.addressConfigurationFlag;
        this.reserved1 = builder.reserved1;
        this.validLifetime = builder.validLifetime;
        this.preferredLifetime = builder.preferredLifetime;
        this.reserved2 = builder.reserved2;
        this.prefix = builder.prefix;
        this.length = builder.correctLengthAtBuild ? (byte)(this.length() / 8) : builder.length;
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte getPrefixLength() {
        return this.prefixLength;
    }

    public int getPrefixLengthAsInt() {
        return 0xFF & this.prefixLength;
    }

    public boolean getOnLinkFlag() {
        return this.onLinkFlag;
    }

    public boolean getAddressConfigurationFlag() {
        return this.addressConfigurationFlag;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public int getValidLifetime() {
        return this.validLifetime;
    }

    public long getValidLifetimeAsLong() {
        return (long)this.validLifetime & 0xFFFFFFFFL;
    }

    public int getPreferredLifetime() {
        return this.preferredLifetime;
    }

    public long getPreferredLifetimeAsLong() {
        return (long)this.preferredLifetime & 0xFFFFFFFFL;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public Inet6Address getPrefix() {
        return this.prefix;
    }

    @Override
    public int length() {
        return 32;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = this.prefixLength;
        rawData[3] = (byte)(0x3F & this.reserved1);
        if (this.onLinkFlag) {
            rawData[3] = (byte)(rawData[3] | 0x80);
        }
        if (this.addressConfigurationFlag) {
            rawData[3] = (byte)(rawData[3] | 0x40);
        }
        System.arraycopy(ByteArrays.toByteArray(this.validLifetime), 0, rawData, 4, 4);
        System.arraycopy(ByteArrays.toByteArray(this.preferredLifetime), 0, rawData, 8, 4);
        System.arraycopy(ByteArrays.toByteArray(this.reserved2), 0, rawData, 12, 4);
        System.arraycopy(ByteArrays.toByteArray(this.prefix), 0, rawData, 16, 16);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.getType());
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" (").append(this.getLengthAsInt() * 8);
        sb.append(" bytes)] [Prefix Length: ").append(this.getPrefixLengthAsInt());
        sb.append("] [on-link flag: ").append(this.getOnLinkFlag());
        sb.append("] [address-configuration flag: ").append(this.getAddressConfigurationFlag());
        sb.append("] [Reserved1: ").append(this.getReserved1());
        sb.append("] [Valid Lifetime: ").append(this.getValidLifetimeAsLong());
        sb.append("] [Preferred Lifetime: ").append(this.getPreferredLifetimeAsLong());
        sb.append("] [Reserved2: ").append(this.getReserved2());
        sb.append("] [Prefix: ").append(this.getPrefix());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6NeighborDiscoveryPrefixInformationOption other = (IpV6NeighborDiscoveryPrefixInformationOption)obj;
        return this.prefix.equals(other.prefix) && this.prefixLength == other.prefixLength && this.validLifetime == other.validLifetime && this.preferredLifetime == other.preferredLifetime && this.onLinkFlag == other.onLinkFlag && this.addressConfigurationFlag == other.addressConfigurationFlag && this.reserved1 == other.reserved1 && this.reserved2 == other.reserved2 && this.length == other.length;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + this.prefixLength;
        result = 31 * result + (this.onLinkFlag ? 1231 : 1237);
        result = 31 * result + (this.addressConfigurationFlag ? 1231 : 1237);
        result = 31 * result + this.reserved1;
        result = 31 * result + this.validLifetime;
        result = 31 * result + this.preferredLifetime;
        result = 31 * result + this.reserved2;
        result = 31 * result + this.prefix.hashCode();
        return result;
    }

    public static final class Builder
    implements LengthBuilder<IpV6NeighborDiscoveryPrefixInformationOption> {
        private byte length;
        private byte prefixLength;
        private boolean onLinkFlag;
        private boolean addressConfigurationFlag;
        private byte reserved1;
        private int validLifetime;
        private int preferredLifetime;
        private int reserved2;
        private Inet6Address prefix;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6NeighborDiscoveryPrefixInformationOption option) {
            this.length = option.length;
            this.prefixLength = option.prefixLength;
            this.onLinkFlag = option.onLinkFlag;
            this.addressConfigurationFlag = option.addressConfigurationFlag;
            this.reserved1 = option.reserved1;
            this.validLifetime = option.validLifetime;
            this.preferredLifetime = option.preferredLifetime;
            this.reserved2 = option.reserved2;
            this.prefix = option.prefix;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder prefixLength(byte prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public Builder onLinkFlag(boolean onLinkFlag) {
            this.onLinkFlag = onLinkFlag;
            return this;
        }

        public Builder addressConfigurationFlag(boolean addressConfigurationFlag) {
            this.addressConfigurationFlag = addressConfigurationFlag;
            return this;
        }

        public Builder reserved1(byte reserved1) {
            this.reserved1 = reserved1;
            return this;
        }

        public Builder validLifetime(int validLifetime) {
            this.validLifetime = validLifetime;
            return this;
        }

        public Builder preferredLifetime(int preferredLifetime) {
            this.preferredLifetime = preferredLifetime;
            return this;
        }

        public Builder reserved2(int reserved2) {
            this.reserved2 = reserved2;
            return this;
        }

        public Builder prefix(Inet6Address prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6NeighborDiscoveryPrefixInformationOption build() {
            return new IpV6NeighborDiscoveryPrefixInformationOption(this);
        }
    }
}

