/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class ForkNumberBucket {
    private static final ForkNumberBucket INSTANCE = new ForkNumberBucket();
    private final Queue<Integer> qFree = new ConcurrentLinkedQueue<Integer>();
    private final AtomicInteger highWaterMark = new AtomicInteger(1);

    private ForkNumberBucket() {
    }

    public static int drawNumber() {
        return ForkNumberBucket.getInstance().drawNumberInternal();
    }

    public static void returnNumber(int number) {
        ForkNumberBucket.getInstance().returnNumberInternal(number);
    }

    private static ForkNumberBucket getInstance() {
        return INSTANCE;
    }

    private int drawNumberInternal() {
        Integer nextFree = this.qFree.poll();
        return nextFree == null ? this.highWaterMark.getAndIncrement() : nextFree.intValue();
    }

    private int getHighestDrawnNumber() {
        return this.highWaterMark.get() - 1;
    }

    private void returnNumberInternal(int number) {
        this.qFree.add(number);
    }
}

