/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.codehaus.mojo.versions.api.Property;

public class PropertiesVersionsFileReader {
    private String propertiesCsv;
    private Property[] propertiesConfig;
    private String propertyFilePath;

    public PropertiesVersionsFileReader(String filePath) {
        this.propertyFilePath = filePath;
    }

    public void read() throws IOException {
        try (InputStream input = Files.newInputStream(Paths.get(this.propertyFilePath, new String[0]), new OpenOption[0]);){
            Properties prop = new Properties();
            prop.load(input);
            prop.propertyNames();
            this.propertiesCsv = prop.keySet().stream().map(Object::toString).collect(Collectors.joining(","));
            ArrayList propertiesConfigList = new ArrayList();
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, version) -> {
                Property propertyConfig = new Property((String)name);
                propertyConfig.setVersion((String)version);
                propertiesConfigList.add(propertyConfig);
            }));
            this.propertiesConfig = propertiesConfigList.toArray(new Property[0]);
        }
    }

    public String getProperties() {
        return this.propertiesCsv;
    }

    public Property[] getPropertiesConfig() {
        return this.propertiesConfig;
    }
}

