/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.util.cio.InputStreamAdaptersKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0012\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lio/ktor/server/http/content/JarFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "zipFilePath", "Ljava/nio/file/Path;", "resourcePath", "", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/nio/file/Path;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "jarFile", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "isFile", "", "()Z", "isFile$delegate", "Lkotlin/Lazy;", "jar", "Ljava/util/jar/JarFile;", "getJar", "()Ljava/util/jar/JarFile;", "jar$delegate", "jarEntry", "Ljava/util/jar/JarEntry;", "getJarEntry", "()Ljava/util/jar/JarEntry;", "jarEntry$delegate", "getJarFile", "()Ljava/io/File;", "normalized", "getResourcePath", "()Ljava/lang/String;", "readFrom", "Lio/ktor/utils/io/ByteReadChannel;", "ktor-server-core"})
public final class JarFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final File jarFile;
    @NotNull
    private final String resourcePath;
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final String normalized;
    @NotNull
    private final Lazy jarEntry$delegate;
    @NotNull
    private final Lazy jar$delegate;
    @NotNull
    private final Lazy isFile$delegate;

    public JarFileContent(@NotNull File jarFile, @NotNull String resourcePath, @NotNull ContentType contentType) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            this.jarFile = jarFile;
            this.resourcePath = resourcePath;
            this.contentType = contentType;
            String string = FilesKt.normalize((File)new File(this.resourcePath)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(resourcePath).normalize().toString()");
            this.normalized = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            this.jarEntry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarEntry>(this){
                final /* synthetic */ JarFileContent this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final JarEntry invoke() {
                    return JarFileContent.access$getJar(this.this$0).getJarEntry(this.this$0.getResourcePath());
                }
            }));
            this.jar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarFile>(this){
                final /* synthetic */ JarFileContent this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final JarFile invoke() {
                    return new JarFile(this.this$0.getJarFile());
                }
            }));
            this.isFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ JarFileContent this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    JarEntry jarEntry2 = JarFileContent.access$getJarEntry(this.this$0);
                    return jarEntry2 != null ? !jarEntry2.isDirectory() : false;
                }
            }));
            if (!(!StringsKt.startsWith$default((String)this.normalized, (String)"..", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string2 = "Bad resource relative path " + this.resourcePath;
                throw new IllegalArgumentException(string2.toString());
            }
            JarEntry jarEntry2 = this.getJarEntry();
            if (jarEntry2 == null) break block1;
            JarEntry it = jarEntry2;
            boolean bl = false;
            OutgoingContent outgoingContent = (OutgoingContent)this;
            Collection collection = VersionsKt.getVersions((OutgoingContent)((OutgoingContent)this));
            FileTime fileTime = it.getLastModifiedTime();
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"it.lastModifiedTime");
            VersionsKt.setVersions((OutgoingContent)outgoingContent, (List)CollectionsKt.plus((Collection)collection, (Object)LastModifiedJavaTimeKt.LastModifiedVersion(fileTime)));
        }
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    private final JarEntry getJarEntry() {
        Lazy lazy = this.jarEntry$delegate;
        return (JarEntry)lazy.getValue();
    }

    private final JarFile getJar() {
        Lazy lazy = this.jar$delegate;
        return (JarFile)lazy.getValue();
    }

    public final boolean isFile() {
        Lazy lazy = this.isFile$delegate;
        return (Boolean)lazy.getValue();
    }

    public JarFileContent(@NotNull Path zipFilePath, @NotNull String resourcePath, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        File file2 = zipFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"zipFilePath.toFile()");
        this(file2, resourcePath, contentType);
    }

    @Nullable
    public Long getContentLength() {
        JarEntry jarEntry2 = this.getJarEntry();
        return jarEntry2 != null ? Long.valueOf(jarEntry2.getSize()) : null;
    }

    @NotNull
    public ByteReadChannel readFrom() {
        InputStream inputStream = this.getJar().getInputStream(this.getJarEntry());
        if (inputStream == null || (inputStream = InputStreamAdaptersKt.toByteReadChannel$default((InputStream)inputStream, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool(), null, null, (int)6, null)) == null) {
            throw new IOException("Resource " + this.normalized + " not found");
        }
        return inputStream;
    }

    public static final /* synthetic */ JarFile access$getJar(JarFileContent $this) {
        return $this.getJar();
    }

    public static final /* synthetic */ JarEntry access$getJarEntry(JarFileContent $this) {
        return $this.getJarEntry();
    }
}

