/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.ArtifactMatcher;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyGraphBuilder;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class BanTransitiveDependencies
extends AbstractNonCacheableEnforcerRule
implements EnforcerRule {
    private EnforcerRuleHelper helper;
    private List<String> excludes;
    private List<String> includes;

    private static boolean searchTree(DependencyNode node, int level, ArtifactMatcher excludes, StringBuilder message) throws InvalidVersionSpecificationException {
        StringBuilder messageFromChildren;
        List children = node.getChildren();
        boolean hasTransitiveDependencies = level > 1;
        boolean excluded = false;
        StringBuilder stringBuilder = messageFromChildren = message == null ? null : new StringBuilder();
        if (excludes.match(node.getArtifact())) {
            excluded = true;
            hasTransitiveDependencies = false;
        } else {
            for (DependencyNode childNode : children) {
                hasTransitiveDependencies = BanTransitiveDependencies.searchTree(childNode, level + 1, excludes, messageFromChildren) || hasTransitiveDependencies;
            }
        }
        if ((excluded || hasTransitiveDependencies) && message != null) {
            for (int i = 0; i < level; ++i) {
                message.append("   ");
            }
            message.append(node.getArtifact());
            if (excluded) {
                message.append(" [excluded]" + System.lineSeparator());
            }
            if (hasTransitiveDependencies) {
                if (level == 1) {
                    message.append(" has transitive dependencies:");
                }
                message.append(System.lineSeparator()).append((CharSequence)messageFromChildren);
            }
        }
        return hasTransitiveDependencies;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.helper = helper;
        if (this.excludes == null) {
            this.excludes = Collections.emptyList();
        }
        if (this.includes == null) {
            this.includes = Collections.emptyList();
        }
        ArtifactMatcher exclusions = new ArtifactMatcher(this.excludes, this.includes);
        DependencyNode rootNode = null;
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            rootNode = this.createDependencyGraphBuilder().buildDependencyGraph(project, null);
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Error: Could not construct dependency tree.", e);
        }
        String message = this.getMessage();
        StringBuilder generatedMessage = null;
        if (message == null) {
            generatedMessage = new StringBuilder();
        }
        try {
            if (BanTransitiveDependencies.searchTree(rootNode, 0, exclusions, generatedMessage)) {
                throw new EnforcerRuleException(message == null ? generatedMessage.toString() : message);
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException("Error: Invalid version range.", (Exception)((Object)e));
        }
    }

    private DependencyGraphBuilder createDependencyGraphBuilder() throws ComponentLookupException {
        DefaultDependencyGraphBuilder builder = (DefaultDependencyGraphBuilder)this.helper.getContainer().lookup(DependencyGraphBuilder.class.getCanonicalName(), "default");
        builder.enableLogging((Logger)new ConsoleLogger(5, "DefaultDependencyGraphBuilder"));
        return builder;
    }
}

