/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J)\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "generateCompanion", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "resolve"})
final class FirCompanionGenerationTransformer
extends FirTransformer {
    @NotNull
    private final FirSession session;

    public FirCompanionGenerationTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2.transformDeclarations(this, data);
    }

    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.generateCompanion(regularClass);
        return regularClass.transformDeclarations(this, data);
    }

    private final void generateCompanion(FirRegularClass regularClass) {
        FirSwitchableExtensionDeclarationsSymbolProvider firSwitchableExtensionDeclarationsSymbolProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
        if (firSwitchableExtensionDeclarationsSymbolProvider == null) {
            return;
        }
        FirSwitchableExtensionDeclarationsSymbolProvider generatedDeclarationProvider = firSwitchableExtensionDeclarationsSymbolProvider;
        ClassId classId = FirDeclarationUtilKt.getClassId(regularClass).createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"regularClass.classId.cre\u2026AME_FOR_COMPANION_OBJECT)");
        ClassId companionClassId = classId;
        FirClassLikeSymbol<?> generatedCompanion = generatedDeclarationProvider.getClassLikeSymbolByClassId(companionClassId);
        if (generatedCompanion != null) {
            if (generatedCompanion instanceof FirRegularClassSymbol) {
                if (regularClass.getCompanionObjectSymbol() != null) {
                    throw new IllegalStateException(("Plugin generated companion object for class " + regularClass + ", but it is already present in class").toString());
                }
                regularClass.replaceCompanionObjectSymbol((FirRegularClassSymbol)generatedCompanion);
            } else {
                throw new IllegalStateException("Plugin generated non regular class as companion object".toString());
            }
        }
    }
}

