/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.ByteNotFoundException;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public interface Buffer
extends Cloneable {
    public void getBytes(Buffer var1);

    public void getBytes(int var1, Buffer var2) throws IndexOutOfBoundsException;

    public void getBytes(byte[] var1) throws IndexOutOfBoundsException;

    @Deprecated
    default public void getByes(byte[] dst) throws IndexOutOfBoundsException {
        this.getBytes(dst);
    }

    public Buffer readBytes(int var1) throws IndexOutOfBoundsException, IOException;

    public Buffer readLine() throws IOException;

    public Buffer readUntilSingleCRLF() throws IOException;

    public Buffer readUntilDoubleCRLF() throws IOException;

    public int getReadableBytes();

    public boolean hasReadableBytes();

    public boolean isEmpty();

    public byte[] getArray();

    default public byte[] getRawArray() {
        return this.getArray();
    }

    public Buffer readUntil(byte var1) throws IOException, ByteNotFoundException;

    public Buffer readUntil(int var1, byte ... var2) throws IOException, ByteNotFoundException, IllegalArgumentException;

    public Buffer readUntilSafe(int var1, byte ... var2) throws IOException, IllegalArgumentException;

    public int indexOf(int var1, byte ... var2) throws IOException, ByteNotFoundException, IllegalArgumentException;

    public int indexOf(byte var1) throws IOException, ByteNotFoundException, IllegalArgumentException;

    public Buffer slice(int var1, int var2);

    public Buffer slice(int var1);

    public Buffer slice();

    public int getLowerBoundary();

    public int getUpperBoundary();

    public int getReaderIndex();

    public void setReaderIndex(int var1);

    public void markReaderIndex();

    public void resetReaderIndex();

    public int capacity();

    public byte getByte(int var1) throws IndexOutOfBoundsException, IOException;

    public byte readByte() throws IndexOutOfBoundsException, IOException;

    public byte peekByte() throws IndexOutOfBoundsException, IOException;

    public long readUnsignedInt() throws IndexOutOfBoundsException;

    public int readInt() throws IndexOutOfBoundsException;

    public int getInt(int var1) throws IndexOutOfBoundsException;

    public void setInt(int var1, int var2) throws IndexOutOfBoundsException;

    public void setUnsignedInt(int var1, long var2) throws IndexOutOfBoundsException;

    public short getShort(int var1) throws IndexOutOfBoundsException;

    public int readUnsignedShort() throws IndexOutOfBoundsException;

    public int getUnsignedShort(int var1) throws IndexOutOfBoundsException;

    public void setUnsignedShort(int var1, int var2) throws IndexOutOfBoundsException;

    public short readShort() throws IndexOutOfBoundsException;

    public short readUnsignedByte() throws IndexOutOfBoundsException, IOException;

    public short getUnsignedByte(int var1) throws IndexOutOfBoundsException;

    public void setUnsignedByte(int var1, short var2) throws IndexOutOfBoundsException;

    public int parseToInt() throws NumberFormatException, IOException;

    public int parseToInt(int var1) throws NumberFormatException, IOException;

    public String dumpAsHex();

    public Buffer clone();

    public void setByte(int var1, byte var2) throws IndexOutOfBoundsException;

    public int getWriterIndex();

    public void setWriterIndex(int var1);

    public int getWritableBytes();

    public boolean hasWritableBytes();

    public boolean hasWriteSupport();

    public void write(byte var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void write(byte[] var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void write(int var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void write(long var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void write(String var1) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException;

    public void writeAsString(int var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void writeAsString(long var1) throws IndexOutOfBoundsException, WriteNotSupportedException;

    public void write(String var1, String var2) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException;

    public boolean equals(Object var1);

    public boolean equalsIgnoreCase(Object var1);

    public int hashCode();

    public String toString();
}

