/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.BaseBuffer;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BoundedInputStreamBuffer
extends BaseBuffer {
    private static final String CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER = "Cannot write to an InputStreamBuffer";
    private static final String NOT_IMPLEMENTED_JUST_YET = "Not implemented just yet";
    private final InputStream is;
    public static final int DEFAULT_CAPACITY = 262144;
    private long readerIndex;
    private long writerIndex;
    final byte[] buffer;
    final int localCapacity;

    public BoundedInputStreamBuffer(InputStream is) {
        this(262144, is);
    }

    public BoundedInputStreamBuffer(int bufferCapacity, InputStream is) {
        assert (is != null);
        this.is = is;
        this.localCapacity = bufferCapacity;
        this.buffer = new byte[bufferCapacity];
    }

    @Override
    public Buffer slice(int start, int stop) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    private static int assertSafeInt(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalStateException("pkts only supports this operation with files/streams less than 2gb. Value=" + value);
        }
        return (int)value;
    }

    @Override
    public byte readByte() throws IndexOutOfBoundsException, IOException {
        int read = this.internalReadBytes(1);
        if (read == -1) {
            throw new IndexOutOfBoundsException();
        }
        return this.getByte(this.readerIndex++);
    }

    @Override
    public byte peekByte() throws IndexOutOfBoundsException, IOException {
        int read = this.internalReadBytes(1);
        if (read == -1) {
            throw new IndexOutOfBoundsException();
        }
        return this.getByte(this.readerIndex);
    }

    @Override
    public Buffer readBytes(int length) throws IndexOutOfBoundsException, IOException {
        int readAtMost;
        if (!this.checkReadableBytesSafe(length)) {
            int availableBytes = this.getReadableBytes();
            int read = this.internalReadBytes(length);
            if (read == -1) {
                return null;
            }
            if (read + availableBytes < length) {
                throw new IndexOutOfBoundsException("Not enough bytes left in the stream. Wanted " + length + " but only read " + read);
            }
        }
        byte[] buf = new byte[length];
        for (int index = 0; index < length; index += readAtMost) {
            int spaceLeft = this.getAvailableLocalReadingSpace();
            readAtMost = Math.min(length - index, spaceLeft);
            int localIndex = this.getLocalReaderIndex();
            System.arraycopy(this.buffer, localIndex, buf, index, readAtMost);
            this.readerIndex += (long)readAtMost;
        }
        return Buffers.wrap(buf);
    }

    private int internalReadBytes(int length) throws IOException {
        if (length > this.localCapacity) {
            throw new IllegalArgumentException("Length is larger than buffer. Request=" + length + ", capacity=" + this.localCapacity);
        }
        if (this.checkReadableBytesSafe(length)) {
            return length;
        }
        return this.readFromStream(length - this.getReadableBytes());
    }

    private int getLocalWriterIndex() {
        return (int)(this.writerIndex % (long)this.localCapacity);
    }

    private int getLocalReaderIndex() {
        return (int)(this.readerIndex % (long)this.localCapacity);
    }

    private int getAvailableLocalWritingSpace() {
        return this.localCapacity - this.getLocalWriterIndex();
    }

    private int getAvailableLocalReadingSpace() {
        return this.localCapacity - this.getLocalReaderIndex();
    }

    private int readFromStream(long length) throws IOException {
        if ((long)this.getReadableBytes() + length > (long)this.localCapacity) {
            throw new IllegalArgumentException("Trying to read too far ahead, will cause wrap-around issues: " + length);
        }
        int total = 0;
        int actual = 0;
        while ((long)total < length && actual != -1) {
            int spaceLeft;
            int readAtMost;
            int localIndex = this.getLocalWriterIndex();
            actual = this.is.read(this.buffer, localIndex, readAtMost = (int)Math.min(length - (long)total, (long)(spaceLeft = this.getAvailableLocalWritingSpace())));
            if (actual <= 0) continue;
            this.writerIndex += (long)actual;
            total += actual;
        }
        return total;
    }

    @Override
    public int getReadableBytes() {
        return BoundedInputStreamBuffer.assertSafeInt(this.writerIndex - this.readerIndex);
    }

    @Override
    public boolean hasReadableBytes() {
        if (!this.checkReadableBytesSafe(1)) {
            try {
                return this.internalReadBytes(100) >= 1;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public byte[] getArray() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public byte getByte(int index) throws IndexOutOfBoundsException, IOException {
        return this.getByte((long)index);
    }

    public byte getByte(long index) throws IndexOutOfBoundsException, IOException {
        this.checkIndex(index);
        return this.buffer[(int)(index % (long)this.localCapacity)];
    }

    private void checkIndex(long index) throws IndexOutOfBoundsException {
        long missingBytes = index + 1L - this.writerIndex;
        if (missingBytes <= 0L) {
            return;
        }
        try {
            int read = this.readFromStream(missingBytes);
            if (read == -1 || (long)read < missingBytes) {
                throw new IndexOutOfBoundsException();
            }
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public long readUnsignedInt() throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int readInt() throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getInt(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public short getShort(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int readUnsignedShort() throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getUnsignedShort(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public short readShort() throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public short getUnsignedByte(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public String dumpAsHex() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setByte(int index, byte value) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setUnsignedByte(int index, short value) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setUnsignedShort(int index, int value) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public Buffer clone() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        try {
            Buffer b = (Buffer)other;
            return Arrays.equals(this.getArray(), b.getArray());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean equalsIgnoreCase(Object other) {
        throw new RuntimeException("Sorry, InputStreamBuffer.equalsIgnoreCase isn't implemented yet");
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getArray());
    }

    @Override
    public String toString() {
        Buffer b = this.slice();
        return b.toString();
    }

    @Override
    public int getWritableBytes() {
        return 0;
    }

    @Override
    public boolean hasWritableBytes() {
        return false;
    }

    @Override
    public void write(byte[] bytes) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void getBytes(Buffer dst) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void getBytes(byte[] dst) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void getBytes(int index, Buffer dst) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void write(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void write(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void writeAsString(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void writeAsString(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void setUnsignedInt(int index, long value) throws IndexOutOfBoundsException {
        throw new WriteNotSupportedException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void write(byte b) throws IndexOutOfBoundsException {
        throw new WriteNotSupportedException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void write(String s) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        throw new WriteNotSupportedException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void write(String s, String charset) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        throw new WriteNotSupportedException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public boolean hasWriteSupport() {
        return false;
    }

    @Override
    public void setWriterIndex(int index) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setReaderIndex(int index) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getReaderIndex() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getWriterIndex() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public final short readUnsignedByte() throws IndexOutOfBoundsException, IOException {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public int capacity() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void resetReaderIndex() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void markReaderIndex() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getLowerBoundary() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public int getUpperBoundary() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public Buffer slice(int stop) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public Buffer slice() {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }
}

