/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.subsystem.security;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.client.core.subsystem.security.User;
import org.sonatype.nexus.client.internal.subsystem.security.UsersImpl;
import org.sonatype.nexus.client.rest.support.EntitySupport;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.rest.model.UserResourceRequest;

public class UserImpl
extends EntitySupport<User, UserResource>
implements User {
    private UsersImpl.UsersClient usersClient;

    public UserImpl(UsersImpl.UsersClient usersClient, UserResource settings) {
        super(settings.getUserId(), settings);
        this.usersClient = usersClient;
    }

    public UserImpl(UsersImpl.UsersClient usersClient, String id) {
        super(id);
        this.usersClient = usersClient;
    }

    @Override
    protected UserResource createSettings(String id) {
        UserResource resource = new UserResource();
        resource.setUserId(id);
        resource.setStatus("active");
        return resource;
    }

    @Override
    protected UserResource doGet() {
        return this.usersClient.get(this.id()).getData();
    }

    @Override
    protected UserResource doCreate() {
        UserResourceRequest request = new UserResourceRequest();
        request.setData((UserResource)this.settings());
        UserResource resource = this.usersClient.post(request).getData();
        resource.setPassword(null);
        return resource;
    }

    @Override
    protected UserResource doUpdate() {
        UserResourceRequest request = new UserResourceRequest();
        request.setData((UserResource)this.settings());
        return this.usersClient.put(this.id(), request).getData();
    }

    @Override
    protected void doRemove() {
        this.usersClient.delete(this.id());
    }

    @Override
    public String firstName() {
        return ((UserResource)this.settings()).getFirstName();
    }

    @Override
    public String lastName() {
        return ((UserResource)this.settings()).getLastName();
    }

    @Override
    public String email() {
        return ((UserResource)this.settings()).getEmail();
    }

    @Override
    public boolean isActive() {
        return "active".equals(((UserResource)this.settings()).getStatus());
    }

    @Override
    public List<String> roles() {
        return Collections.unmodifiableList(((UserResource)this.settings()).getRoles());
    }

    @Override
    public User withPassword(String value) {
        Preconditions.checkState((boolean)this.shouldCreate(), (Object)"Password can only be set when user is created");
        ((UserResource)this.settings()).setPassword(value);
        return this;
    }

    @Override
    public User withFirstName(String value) {
        ((UserResource)this.settings()).setFirstName(value);
        return this;
    }

    @Override
    public User withLastName(String value) {
        ((UserResource)this.settings()).setLastName(value);
        return this;
    }

    @Override
    public User withEmail(String value) {
        ((UserResource)this.settings()).setEmail(value);
        return this;
    }

    @Override
    public User enableAccess() {
        ((UserResource)this.settings()).setStatus("active");
        return this;
    }

    @Override
    public User disableAccess() {
        ((UserResource)this.settings()).setStatus("disabled");
        return this;
    }

    @Override
    public User withRole(String value) {
        ((UserResource)this.settings()).addRole(value);
        return this;
    }

    @Override
    public User removeRole(String value) {
        ((UserResource)this.settings()).removeRole(value);
        return this;
    }
}

