/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.targets;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.targets.RepositoryTarget;
import org.sonatype.nexus.client.core.subsystem.targets.RepositoryTargets;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.targets.JerseyRepositoryTarget;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryTargetListResource;
import org.sonatype.nexus.rest.model.RepositoryTargetListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResourceResponse;

public class JerseyRepositoryTargets
extends SubsystemSupport<JerseyNexusClient>
implements RepositoryTargets {
    public JerseyRepositoryTargets(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    @Override
    public JerseyRepositoryTarget create(String id) {
        return new JerseyRepositoryTarget((JerseyNexusClient)this.getNexusClient(), id);
    }

    @Override
    public RepositoryTarget get(String id) {
        try {
            return this.convert(((RepositoryTargetResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRepositoryTargets.path(id)).get(RepositoryTargetResourceResponse.class)).getData());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public Collection<RepositoryTarget> get() {
        RepositoryTargetListResourceResponse privileges;
        try {
            privileges = (RepositoryTargetListResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repo_targets").get(RepositoryTargetListResourceResponse.class);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        return Collections2.transform((Collection)privileges.getData(), (Function)new Function<RepositoryTargetListResource, RepositoryTarget>(){

            public RepositoryTarget apply(@Nullable RepositoryTargetListResource input) {
                return JerseyRepositoryTargets.this.convert(input);
            }
        });
    }

    private JerseyRepositoryTarget convert(@Nullable RepositoryTargetListResource resource) {
        if (resource == null) {
            return null;
        }
        return this.convert(this.otherDTO(resource));
    }

    private JerseyRepositoryTarget convert(@Nullable RepositoryTargetResource resource) {
        if (resource == null) {
            return null;
        }
        JerseyRepositoryTarget privilege = new JerseyRepositoryTarget((JerseyNexusClient)this.getNexusClient(), resource.getId(), resource);
        privilege.overwriteWith(resource);
        return privilege;
    }

    private RepositoryTargetResource otherDTO(RepositoryTargetListResource resource) {
        RepositoryTargetResource targetResource = new RepositoryTargetResource();
        try {
            BeanUtils.copyProperties((Object)targetResource, (Object)resource);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return targetResource;
    }

    static String path(String id) {
        try {
            return "repo_targets/" + URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

