/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging;

import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging.AnsiMessageBuilder;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging.PlainMessageBuilder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class MessageUtils {
    private static final boolean JANSI;

    public static void systemInstall() {
        if (JANSI) {
            AnsiConsole.systemInstall();
        }
    }

    public static void systemUninstall() {
        if (JANSI) {
            AnsiConsole.systemUninstall();
        }
    }

    public static void setColorEnabled(boolean flag) {
        if (JANSI) {
            Ansi.setEnabled((boolean)flag);
        }
    }

    public static boolean isColorEnabled() {
        return JANSI ? Ansi.isEnabled() : false;
    }

    public static MessageBuilder buffer() {
        return JANSI ? new AnsiMessageBuilder() : new PlainMessageBuilder();
    }

    public static MessageBuilder buffer(StringBuilder builder) {
        return JANSI ? new AnsiMessageBuilder(builder) : new PlainMessageBuilder(builder);
    }

    public static MessageBuilder buffer(int size) {
        return JANSI ? new AnsiMessageBuilder(size) : new PlainMessageBuilder(size);
    }

    public static String stripAnsiCodes(String msg) {
        return msg.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    static {
        boolean jansi = true;
        try {
            Class.forName("org.fusesource.jansi.Ansi");
        }
        catch (ClassNotFoundException cnfe) {
            jansi = false;
        }
        JANSI = jansi;
    }
}

