/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack.timers;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultSipTimer
extends Timer
implements SipTimer {
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected SipStackImpl sipStackImpl;

    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        super.schedule((TimerTask)new DefaultTimerTask(task), delay);
        return true;
    }

    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        super.schedule((TimerTask)new DefaultTimerTask(task), delay, period);
        return true;
    }

    public boolean cancel(SIPStackTimerTask task) {
        return ((TimerTask)task.getSipTimerTask()).cancel();
    }

    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.started.set(true);
        if (this.sipStackImpl.getStackLogger().isLoggingEnabled(16)) {
            this.sipStackImpl.getStackLogger().logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    public void stop() {
        this.started.set(false);
        this.cancel();
        this.sipStackImpl.getStackLogger().logStackTrace(32);
        if (this.sipStackImpl.getStackLogger().isLoggingEnabled(16)) {
            this.sipStackImpl.getStackLogger().logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private class DefaultTimerTask
    extends TimerTask {
        private SIPStackTimerTask task;

        public DefaultTimerTask(SIPStackTimerTask task) {
            this.task = task;
            task.setSipTimerTask(this);
        }

        public void run() {
            try {
                if (this.task != null) {
                    this.task.runTask();
                }
            }
            catch (Throwable e) {
                System.out.println("SIP stack timer task failed due to exception:");
                e.printStackTrace();
            }
        }

        public boolean cancel() {
            if (this.task != null) {
                this.task.cleanUpBeforeCancel();
                this.task = null;
            }
            return super.cancel();
        }
    }
}

