/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.Iterator;
import java.util.List;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheUtils {
    public static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static int repositoriesHashCode(List<RemoteRepository> repositories) {
        int result = 17;
        for (RemoteRepository repository : repositories) {
            result = 31 * result + CacheUtils.repositoryHashCode(repository);
        }
        return result;
    }

    private static int repositoryHashCode(RemoteRepository repository) {
        int result = 17;
        result = 31 * result + CacheUtils.hash(repository.getUrl());
        return result;
    }

    private static boolean repositoryEquals(RemoteRepository r1, RemoteRepository r2) {
        if (r1 == r2) {
            return true;
        }
        return CacheUtils.eq(r1.getId(), r2.getId()) && CacheUtils.eq(r1.getUrl(), r2.getUrl()) && CacheUtils.policyEquals(r1.getPolicy(false), r2.getPolicy(false)) && CacheUtils.policyEquals(r1.getPolicy(true), r2.getPolicy(true));
    }

    private static boolean policyEquals(RepositoryPolicy p1, RepositoryPolicy p2) {
        if (p1 == p2) {
            return true;
        }
        return p1.isEnabled() == p2.isEnabled() && CacheUtils.eq(p1.getChecksumPolicy(), p2.getChecksumPolicy());
    }

    public static boolean repositoriesEquals(List<RemoteRepository> r1, List<RemoteRepository> r2) {
        if (r1.size() != r2.size()) {
            return false;
        }
        Iterator<RemoteRepository> it1 = r1.iterator();
        Iterator<RemoteRepository> it2 = r2.iterator();
        while (it1.hasNext()) {
            if (CacheUtils.repositoryEquals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static WorkspaceRepository getWorkspace(RepositorySystemSession session) {
        WorkspaceReader reader = session.getWorkspaceReader();
        return reader != null ? reader.getRepository() : null;
    }

    public static ArtifactRepository getRepository(RepositorySystemSession session, List<RemoteRepository> repositories, Class<?> repoClass, String repoId) {
        if (repoClass != null) {
            if (WorkspaceRepository.class.isAssignableFrom(repoClass)) {
                return session.getWorkspaceReader().getRepository();
            }
            if (LocalRepository.class.isAssignableFrom(repoClass)) {
                return session.getLocalRepository();
            }
            for (RemoteRepository repository : repositories) {
                if (!repoId.equals(repository.getId())) continue;
                return repository;
            }
        }
        return null;
    }
}

