/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.inputevt;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import org.jitsi.xmpp.extensions.inputevt.RemoteControlExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class RemoteControlExtensionProvider
extends ExtensionElementProvider<RemoteControlExtension> {
    public static final String ELEMENT_REMOTE_CONTROL = "remote-control";
    public static final String ELEMENT_MOUSE_MOVE = "mouse-move";
    public static final String ELEMENT_MOUSE_WHEEL = "mouse-wheel";
    public static final String ELEMENT_MOUSE_PRESS = "mouse-press";
    public static final String ELEMENT_MOUSE_RELEASE = "mouse-release";
    public static final String ELEMENT_KEY_PRESS = "key-press";
    public static final String ELEMENT_KEY_RELEASE = "key-release";
    public static final String ELEMENT_KEY_TYPE = "key-type";
    public static final String NAMESPACE = "http://jitsi.org/protocol/inputevt";
    private static final Component component = new Canvas();

    public RemoteControlExtension parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        RemoteControlExtension result = null;
        boolean done = false;
        while (!done) {
            try {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    KeyEvent ke;
                    MouseEvent me;
                    String attr;
                    if (parser.getName().equals(ELEMENT_MOUSE_MOVE)) {
                        attr = parser.getAttributeValue("", "x");
                        String attr2 = parser.getAttributeValue("", "y");
                        if (attr != null && attr2 != null) {
                            int x = (int)(Double.parseDouble(attr) * 1000.0);
                            int y = (int)(Double.parseDouble(attr2) * 1000.0);
                            MouseEvent me2 = new MouseEvent(component, 503, System.currentTimeMillis(), 0, x, y, 0, false, 0);
                            result = new RemoteControlExtension(me2);
                            continue;
                        }
                    }
                    if (parser.getName().equals(ELEMENT_MOUSE_WHEEL) && (attr = parser.getAttributeValue("", "notch")) != null) {
                        me = new MouseWheelEvent(component, 507, System.currentTimeMillis(), 0, 0, 0, 0, false, 0, 0, Integer.parseInt(attr));
                        result = new RemoteControlExtension(me);
                        continue;
                    }
                    if (parser.getName().equals(ELEMENT_MOUSE_PRESS) && (attr = parser.getAttributeValue("", "btns")) != null) {
                        me = new MouseEvent(component, 501, System.currentTimeMillis(), Integer.parseInt(attr), 0, 0, 0, false, 0);
                        result = new RemoteControlExtension(me);
                        continue;
                    }
                    if (parser.getName().equals(ELEMENT_MOUSE_RELEASE) && (attr = parser.getAttributeValue("", "btns")) != null) {
                        me = new MouseEvent(component, 502, System.currentTimeMillis(), Integer.parseInt(attr), 0, 0, 0, false, 0);
                        result = new RemoteControlExtension(me);
                        continue;
                    }
                    if (parser.getName().equals(ELEMENT_KEY_PRESS) && (attr = parser.getAttributeValue("", "keycode")) != null) {
                        ke = new KeyEvent(component, 401, System.currentTimeMillis(), 0, Integer.parseInt(attr), '\u0000');
                        result = new RemoteControlExtension(ke);
                        continue;
                    }
                    if (parser.getName().equals(ELEMENT_KEY_RELEASE) && (attr = parser.getAttributeValue("", "keycode")) != null) {
                        ke = new KeyEvent(component, 402, System.currentTimeMillis(), 0, Integer.parseInt(attr), '\u0000');
                        result = new RemoteControlExtension(ke);
                        continue;
                    }
                    if (!parser.getName().equals(ELEMENT_KEY_TYPE) || (attr = parser.getAttributeValue("", "keychar")) == null) continue;
                    ke = new KeyEvent(component, 400, System.currentTimeMillis(), 0, 0, (char)Integer.parseInt(attr));
                    result = new RemoteControlExtension(ke);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(ELEMENT_REMOTE_CONTROL)) continue;
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (result == null) {
            result = new RemoteControlExtension(new ComponentEvent(component, 0));
        }
        return result;
    }

    private static void append(StringBuffer stringBuffer, String ... strings) {
        for (String str : strings) {
            stringBuffer.append(str);
        }
    }

    public static String getKeyPressedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_KEY_PRESS);
        RemoteControlExtensionProvider.append(xml, " keycode=\"", Integer.toString(keycode), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getKeyReleasedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_KEY_RELEASE);
        RemoteControlExtensionProvider.append(xml, " keycode=\"", Integer.toString(keycode), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getKeyTypedXML(int keycode) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_KEY_TYPE);
        RemoteControlExtensionProvider.append(xml, " keychar=\"", Integer.toString(keycode), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getMousePressedXML(int btns) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_MOUSE_PRESS);
        RemoteControlExtensionProvider.append(xml, " btns=\"", Integer.toString(btns), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getMouseReleasedXML(int btns) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_MOUSE_RELEASE);
        RemoteControlExtensionProvider.append(xml, " btns=\"", Integer.toString(btns), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getMouseMovedXML(double x, double y) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_MOUSE_MOVE);
        RemoteControlExtensionProvider.append(xml, " x=\"", Double.toString(x), "\" y=\"", Double.toString(y), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }

    public static String getMouseWheelXML(int notch) {
        StringBuffer xml = new StringBuffer();
        RemoteControlExtensionProvider.append(xml, "<remote-control xmlns=\"http://jitsi.org/protocol/inputevt\">");
        RemoteControlExtensionProvider.append(xml, "<", ELEMENT_MOUSE_WHEEL);
        RemoteControlExtensionProvider.append(xml, " notch=\"", Integer.toString(notch), "\"/>");
        RemoteControlExtensionProvider.append(xml, "</remote-control>");
        return xml.toString();
    }
}

