/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class Sctp
extends AbstractPacketExtension {
    public static final String ELEMENT = "sctp";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "sctp");
    public static final String PORT_ATTR_NAME = "port";
    public static final String ROLE_ATTR_NAME = "role";

    private Sctp(Builder b) {
        this();
        if (b.role != null) {
            this.setAttribute(ROLE_ATTR_NAME, b.role.toString().toLowerCase());
        }
        if (b.port != null) {
            this.setAttribute(PORT_ATTR_NAME, b.port.toString());
        }
    }

    public Sctp() {
        super(NAMESPACE, ELEMENT);
    }

    @Nullable
    public Role getRole() {
        String roleString = this.getAttributeAsString(ROLE_ATTR_NAME);
        if (roleString == null) {
            return null;
        }
        return Role.valueOf(roleString.toUpperCase());
    }

    @Nullable
    public Integer getPort() {
        String portString = this.getAttributeAsString(PORT_ATTR_NAME);
        if (portString == null) {
            return null;
        }
        return Integer.parseInt(portString);
    }

    public static enum Role {
        CLIENT,
        SERVER;


        public static Role parseString(String s) {
            return Role.valueOf(s.toUpperCase());
        }
    }

    public static class Builder {
        private Integer port;
        private Role role;

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setRole(@NotNull Role role) {
            this.role = role;
            return this;
        }

        public Sctp build() {
            return new Sctp(this);
        }
    }

    public static class Provider
    extends DefaultPacketExtensionProvider<Sctp> {
        public Provider() {
            super(Sctp.class);
        }

        @Override
        public Sctp parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            String port;
            Sctp sctp = (Sctp)super.parse(parser, depth, xmlEnvironment);
            String role = sctp.getAttributeAsString(Sctp.ROLE_ATTR_NAME);
            if (role != null) {
                try {
                    Role.parseString(role);
                }
                catch (IllegalArgumentException e) {
                    throw new SmackParsingException("Invalid value for the 'role' attribute: " + role);
                }
            }
            if ((port = sctp.getAttributeAsString(Sctp.PORT_ATTR_NAME)) != null) {
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException e) {
                    throw new SmackParsingException("Invalid value for the 'port' attribute: " + port);
                }
            }
            return sctp;
        }
    }
}

