/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.classpathDiff.ContentHashJavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ContentHashJavaClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ProtoBasedJavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ProtoBasedJavaClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularJavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularJavaClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/JavaClassSnapshotExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/JavaClassSnapshot;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "snapshot", "incremental-compilation-impl"})
public final class JavaClassSnapshotExternalizer
implements DataExternalizer<JavaClassSnapshot> {
    @NotNull
    public static final JavaClassSnapshotExternalizer INSTANCE = new JavaClassSnapshotExternalizer();

    private JavaClassSnapshotExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull JavaClassSnapshot snapshot2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
        String string2 = snapshot2.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"snapshot.javaClass.name");
        ExternalizersKt.writeString(output, string2);
        JavaClassSnapshot javaClassSnapshot = snapshot2;
        if (javaClassSnapshot instanceof RegularJavaClassSnapshot) {
            RegularJavaClassSnapshotExternalizer.INSTANCE.save(output, (RegularJavaClassSnapshot)snapshot2);
        } else if (javaClassSnapshot instanceof ProtoBasedJavaClassSnapshot) {
            ProtoBasedJavaClassSnapshotExternalizer.INSTANCE.save(output, (ProtoBasedJavaClassSnapshot)snapshot2);
        } else if (javaClassSnapshot instanceof ContentHashJavaClassSnapshot) {
            ContentHashJavaClassSnapshotExternalizer.INSTANCE.save(output, (ContentHashJavaClassSnapshot)snapshot2);
        }
    }

    @Override
    @NotNull
    public JavaClassSnapshot read(@NotNull DataInput input) {
        JavaClassSnapshot javaClassSnapshot;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String className2 = ExternalizersKt.readString(input);
        if (Intrinsics.areEqual((Object)className2, (Object)RegularJavaClassSnapshot.class.getName())) {
            javaClassSnapshot = RegularJavaClassSnapshotExternalizer.INSTANCE.read(input);
        } else if (Intrinsics.areEqual((Object)className2, (Object)ProtoBasedJavaClassSnapshot.class.getName())) {
            javaClassSnapshot = ProtoBasedJavaClassSnapshotExternalizer.INSTANCE.read(input);
        } else if (Intrinsics.areEqual((Object)className2, (Object)ContentHashJavaClassSnapshot.class.getName())) {
            javaClassSnapshot = ContentHashJavaClassSnapshotExternalizer.INSTANCE.read(input);
        } else {
            throw new IllegalStateException(("Unrecognized class name: " + className2).toString());
        }
        return javaClassSnapshot;
    }
}

