/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteComparators;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import java.util.Comparator;
import java.util.List;

public interface ByteList
extends ByteCollection,
Comparable<List<? extends Byte>>,
List<Byte> {
    @Override
    public ByteListIterator iterator();

    public ByteListIterator listIterator();

    public ByteListIterator listIterator(int var1);

    public ByteList subList(int var1, int var2);

    public void removeElements(int var1, int var2);

    default public void setElements(byte[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, byte[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, byte[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        ByteArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        ByteListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextByte();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(byte var1);

    @Override
    public void add(int var1, byte var2);

    @Override
    @Deprecated
    default public void add(int index2, Byte key) {
        this.add(index2, (byte)key);
    }

    @Override
    public byte set(int var1, byte var2);

    public byte getByte(int var1);

    public int indexOf(byte var1);

    public int lastIndexOf(byte var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return ByteCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Byte get(int index2) {
        return this.getByte(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Byte)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Byte)o);
    }

    @Override
    @Deprecated
    default public boolean add(Byte k) {
        return this.add((byte)k);
    }

    public byte removeByte(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return ByteCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Byte remove(int index2) {
        return this.removeByte(index2);
    }

    @Override
    @Deprecated
    default public Byte set(int index2, Byte k) {
        return this.set(index2, (byte)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Byte> comparator) {
        this.sort(ByteComparators.asByteComparator(comparator));
    }

    default public void sort(ByteComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            byte[] elements = this.toByteArray();
            ByteArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(ByteComparator comparator) {
        byte[] elements = this.toByteArray();
        if (comparator == null) {
            ByteArrays.unstableSort(elements);
        } else {
            ByteArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

