/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            OptionTagBinding.$$$reportNull$$$0(0);
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = StringUtil.internEmptyString(optionTag.nameAttribute());
            this.myValueAttribute = StringUtil.internEmptyString(optionTag.valueAttribute());
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context2, @NotNull Element element) {
        Attribute valueAttribute;
        if (context2 == null) {
            OptionTagBinding.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(5);
        }
        if ((valueAttribute = element.getAttribute(this.myValueAttribute)) == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context2, this.myBinding.deserializeUnsafe(context2, element));
            } else {
                List<Element> children2 = element.getChildren();
                if (children2.isEmpty()) {
                    if (this.myBinding instanceof CollectionBinding || this.myBinding instanceof MapBinding) {
                        Object newValue2;
                        Object oldValue = this.myAccessor.read(context2);
                        if (oldValue != null && oldValue != (newValue2 = ((MultiNodeBinding)this.myBinding).deserializeList(oldValue, children2))) {
                            this.myAccessor.set(context2, newValue2);
                        }
                    } else {
                        this.myAccessor.set(context2, null);
                    }
                } else {
                    Object newValue3;
                    assert (this.myBinding != null);
                    Object oldValue = this.myAccessor.read(context2);
                    if (oldValue != (newValue3 = Binding.deserializeList(this.myBinding, oldValue, children2))) {
                        this.myAccessor.set(context2, newValue3);
                    }
                }
            }
        } else {
            String value2 = valueAttribute.getValue();
            if (this.myConverter == null) {
                try {
                    XmlSerializerImpl.doSet(context2, value2, this.myAccessor, ClassUtil.typeToClass(this.myAccessor.getGenericType()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set value for field " + this.myName, e);
                }
            } else {
                this.myAccessor.set(context2, this.myConverter.fromString(value2));
            }
        }
        Object object = context2;
        if (object == null) {
            OptionTagBinding.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            OptionTagBinding.$$$reportNull$$$0(7);
        }
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/OptionTagBinding";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

