/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.rtp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class RtpPacketImpl
extends AbstractPacket
implements RtpPacket {
    private final TransportPacket parent;
    private final Buffer headers;
    private final Buffer payload;

    public RtpPacketImpl(TransportPacket parent, Buffer headers, Buffer payload) {
        super(Protocol.RTP, parent, payload);
        this.parent = parent;
        this.headers = headers;
        this.payload = payload;
    }

    @Override
    public int getVersion() {
        try {
            return (this.headers.getByte(0) & 0xC0) >> 6;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Unable to parse out the RTP version, not enough data", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse out the RTP version, IOException when trying.", e);
        }
    }

    @Override
    public boolean hasPadding() throws IOException {
        return (this.headers.getByte(0) & 0x20) == 32;
    }

    @Override
    public boolean hasExtensions() throws IOException {
        return (this.headers.getByte(0) & 0x10) == 16;
    }

    @Override
    public boolean hasMarker() throws IOException {
        return (this.headers.getByte(1) & 0xFF & 0x80) == 128;
    }

    @Override
    public int getPayloadType() throws IOException {
        return this.headers.getByte(1) & 0xFF & 0x7F;
    }

    @Override
    public int getSeqNumber() throws IOException {
        return this.headers.getShort(2);
    }

    @Override
    public long getTimestamp() throws IOException {
        return (long)(this.headers.getByte(4) & 0xFF) << 24 | (long)(this.headers.getByte(5) & 0xFF) << 16 | (long)(this.headers.getByte(6) & 0xFF) << 8 | (long)(this.headers.getByte(7) & 0xFF);
    }

    @Override
    public long getSyncronizationSource() throws IOException {
        return (long)(this.headers.getByte(8) & 0xFF) << 24 | (long)(this.headers.getByte(9) & 0xFF) << 16 | (long)(this.headers.getByte(10) & 0xFF) << 8 | (long)(this.headers.getByte(11) & 0xFF);
    }

    @Override
    public int getContributingSource() throws IOException {
        return this.headers.getByte(0) & 0xF;
    }

    @Override
    public void verify() {
    }

    @Override
    public long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            TransportPacket transportPacket = this.getParentPacket();
            IPPacket ipPacket = transportPacket.getParentPacket();
            sb.append("Seq=").append(this.getSeqNumber()).append(" type=").append(this.getPayloadType()).append(" src=").append(ipPacket.getSourceIP()).append(":").append(transportPacket.getSourcePort()).append(" dst=").append(ipPacket.getDestinationIP()).append(":").append(transportPacket.getDestinationPort());
            return sb.toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    @Override
    public byte[] dumpPacket() {
        int headerLength = this.headers.capacity();
        int payloadLength = this.payload.capacity();
        byte[] dump = new byte[headerLength + payloadLength];
        System.arraycopy(this.headers.getArray(), 0, dump, 0, headerLength);
        System.arraycopy(this.payload.getArray(), 0, dump, headerLength, payloadLength);
        return dump;
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        throw new RuntimeException("Sorry, not implemented just yet.");
    }

    @Override
    public RtpPacket clone() {
        throw new RuntimeException("Sorry, not implemented just yet");
    }

    @Override
    public Packet getNextPacket() throws IOException {
        return null;
    }

    @Override
    public TransportPacket getParentPacket() {
        return (TransportPacket)super.getParentPacket();
    }
}

