/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.framer.TCPFramer;
import io.pkts.framer.UDPFramer;
import io.pkts.packet.IPv6Packet;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IPv6PacketImpl
extends AbstractPacket
implements IPv6Packet {
    public static final int FIXED_HEADER_LENGTH = 40;
    private static final UDPFramer udpFramer = new UDPFramer();
    private static final TCPFramer tcpFramer = new TCPFramer();
    private final Buffer headers;
    private final int nextProtocol;

    public IPv6PacketImpl(Packet parent, Buffer headers, int nextProtocol, Buffer payload) {
        super(Protocol.IPv6, parent, payload);
        assert (parent != null);
        assert (headers != null);
        this.headers = headers;
        this.nextProtocol = nextProtocol;
    }

    @Override
    public byte[] getRawSourceIP() {
        Buffer tmp = Buffers.createBuffer((int)16);
        this.headers.getBytes(8, tmp);
        return tmp.getArray();
    }

    @Override
    public void setSourceIP(String sourceIp) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getSourceIP() {
        try {
            return InetAddress.getByAddress(this.getRawSourceIP()).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public byte[] getRawDestinationIP() {
        Buffer tmp = Buffers.createBuffer((int)16);
        this.headers.getBytes(24, tmp);
        return tmp.getArray();
    }

    @Override
    public void setDestinationIP(String destinationIP) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getDestinationIP() {
        try {
            return InetAddress.getByAddress(this.getRawDestinationIP()).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public long getArrivalTime() {
        return this.getParentPacket().getArrivalTime();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        Buffer pkt = Buffers.wrap((Buffer)this.headers, (Buffer)payload);
        this.getParentPacket().write(out, pkt);
    }

    @Override
    public int getTotalIPLength() {
        return 40 + this.headers.getUnsignedShort(4);
    }

    public void setRawSourceIP(byte[] ip) {
        this.headers.setWriterIndex(8);
        this.headers.write(ip);
    }

    public void setRawDestinationIP(byte[] ip) {
        this.headers.setWriterIndex(24);
        this.headers.write(ip);
    }

    @Override
    public IPv6Packet clone() {
        Packet parent = this.getParentPacket().clone();
        IPv6PacketImpl pkt = new IPv6PacketImpl(parent, this.headers.clone(), this.nextProtocol, this.getPayload().clone());
        return pkt;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        Buffer payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        Protocol protocol = Protocol.valueOf((byte)this.nextProtocol);
        if (protocol != null) {
            switch (protocol) {
                case UDP: {
                    return udpFramer.frame(this, payload);
                }
                case TCP: {
                    return tcpFramer.frame(this, payload);
                }
            }
            throw new PacketParseException(0, "Unsupported inner protocol for IPv6");
        }
        throw new PacketParseException(0, String.format("Unknown protocol %d inside IPv6 packet", this.nextProtocol));
    }

    @Override
    public int getVersion() {
        return 6;
    }

    @Override
    public int getHeaderLength() {
        return this.headers.capacity();
    }

    @Override
    public int getIdentification() {
        try {
            return (this.headers.getByte(1) & 0xF) << 16 | this.headers.getUnsignedShort(2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isFragmented() {
        return this.getHeader(44) != null;
    }

    @Override
    public short getFragmentOffset() {
        Buffer fragmentHeader = this.getHeader(44);
        if (fragmentHeader != null) {
            int offset = (fragmentHeader.getShort(2) & 0xFFF8) >> 3;
            return (short)(offset * 8);
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IPv6 ");
        sb.append(" Total Length: ").append(this.getTotalIPLength()).append(" ID: ").append(this.getIdentification()).append(" Fragment Offset: ").append(this.getFragmentOffset());
        return sb.toString();
    }

    private Buffer getHeader(int extensionNumber) {
        try {
            int headerExtensionLen;
            byte thisHeaderNumber = this.headers.getByte(6);
            for (int startOfHeader = 40; startOfHeader < this.headers.capacity(); startOfHeader += headerExtensionLen) {
                byte nextHeaderNumber;
                switch (extensionNumber) {
                    case 0: 
                    case 43: 
                    case 60: {
                        nextHeaderNumber = this.headers.getByte(startOfHeader);
                        headerExtensionLen = 8 + this.headers.getByte(startOfHeader + 1) * 8;
                        break;
                    }
                    case 44: {
                        nextHeaderNumber = this.headers.getByte(startOfHeader);
                        headerExtensionLen = 8;
                        break;
                    }
                    case 51: {
                        nextHeaderNumber = this.headers.getByte(startOfHeader);
                        headerExtensionLen = 4 * (this.headers.getByte(startOfHeader + 1) + 2);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (thisHeaderNumber == extensionNumber) {
                    return this.headers.slice(startOfHeader, startOfHeader + headerExtensionLen);
                }
                thisHeaderNumber = nextHeaderNumber;
            }
        }
        catch (IOException e) {
            throw new PacketParseException(0, String.format("Error extracting extension header %d", extensionNumber), e);
        }
        return null;
    }
}

