/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output;

import org.jetbrains.kotlin.org.jdom.internal.SystemProperty;

public enum LineSeparator {
    CRNL("\r\n"),
    NL("\n"),
    CR("\r"),
    DOS("\r\n"),
    UNIX("\n"),
    SYSTEM(SystemProperty.get("line.separator", "\r\n")),
    NONE(null),
    DEFAULT(LineSeparator.getDefaultLineSeparator());

    private final String value;

    private static String getDefaultLineSeparator() {
        String prop2 = SystemProperty.get("org.jetbrains.kotlin.org.jdom.output.LineSeparator", "DEFAULT");
        if ("DEFAULT".equals(prop2)) {
            return "\r\n";
        }
        if ("SYSTEM".equals(prop2)) {
            return System.getProperty("line.separator");
        }
        if ("CRNL".equals(prop2)) {
            return "\r\n";
        }
        if ("NL".equals(prop2)) {
            return "\n";
        }
        if ("CR".equals(prop2)) {
            return "\r";
        }
        if ("DOS".equals(prop2)) {
            return "\r\n";
        }
        if ("UNIX".equals(prop2)) {
            return "\n";
        }
        if ("NONE".equals(prop2)) {
            return null;
        }
        return prop2;
    }

    private LineSeparator(String value2) {
        this.value = value2;
    }

    public String value() {
        return this.value;
    }
}

