/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableList<E>
extends AbstractCollection<E>
implements List<E> {
    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> c) {
        if (c == null) {
            ImmutableList.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index2, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index2, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> it = this.listIterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return it.previousIndex();
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return it.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<E> it = this.listIterator(this.size());
        if (o == null) {
            while (it.hasPrevious()) {
                if (it.previous() != null) continue;
                return it.nextIndex();
            }
        } else {
            while (it.hasPrevious()) {
                if (!o.equals(it.previous())) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.listIterator(0);
        if (listIterator == null) {
            ImmutableList.$$$reportNull$$$0(1);
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        return new ListItr(index2);
    }

    @Override
    @NotNull
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        if (this instanceof SubList) {
            List original = ((SubList)this).l;
            int originalOffset = ((SubList)this).offset;
            return new SubList(original, fromIndex + originalOffset, toIndex + originalOffset);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            E o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static <T> ImmutableList<T> singleton(T element) {
        return new Singleton<T>(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ImmutableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ImmutableList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Singleton<E>
    extends ImmutableList<E> {
        private final E element;

        Singleton(E e) {
            this.element = e;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index2) {
            if (index2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size());
            }
            return this.element;
        }
    }

    private static class SubList<E>
    extends ImmutableList<E> {
        private final List<? extends E> l;
        private final int offset;
        private final int size;

        SubList(@NotNull List<? extends E> list2, int fromIndex, int toIndex) {
            if (list2 == null) {
                SubList.$$$reportNull$$$0(0);
            }
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list2.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.l = list2;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public E get(int index2) {
            if (index2 < 0 || index2 >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
            }
            return this.l.get(index2 + this.offset);
        }

        @Override
        public int size() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ImmutableList$SubList", "<init>"));
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index2) {
            this.cursor = index2;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                int i = this.cursor - 1;
                Object previous = ImmutableList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableList.this.size();
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                Object next = ImmutableList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

