/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnBooleanExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
final class WhenOnBooleanExhaustivenessChecker
implements WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnBooleanExhaustivenessChecker INSTANCE = new WhenOnBooleanExhaustivenessChecker();

    private WhenOnBooleanExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean containsFalse = false;
        boolean containsTrue = false;
        for (KtWhenEntry whenEntry : expression2.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            Intrinsics.checkNotNullExpressionValue((Object)whenEntry.getConditions(), (String)"whenEntry.conditions");
            for (KtWhenCondition whenCondition : ktWhenConditionArray) {
                if (!(whenCondition instanceof KtWhenConditionWithExpression)) continue;
                KtExpression whenExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                if (CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, context2, true)) {
                    containsTrue = true;
                }
                if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, context2, false)) continue;
                containsFalse = true;
            }
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)(!containsTrue ? CollectionsKt.listOf((Object)WhenMissingCase.BooleanIsMissing.TrueIsMissing.INSTANCE) : CollectionsKt.emptyList()), (Iterable)(!containsFalse ? CollectionsKt.listOf((Object)WhenMissingCase.BooleanIsMissing.FalseIsMissing.INSTANCE) : CollectionsKt.emptyList())), (Iterable)WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, nullable));
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        return KotlinBuiltIns.isBoolean(TypeUtils.makeNotNullable(subjectType));
    }
}

