/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010 \u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eJ\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u0014\u0010$\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "globalTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;)V", "globalDeclarationTable", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "allocateIndexedSignature", "declaration", "compatibleMode", "", "assumeDeclarationSignature", "", "signature", "computeSignatureByDeclaration", "inFile", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "isExportedDeclaration", "privateDeclarationSignature", "builder", "signatureByDeclaration", "tryComputeBackendSpecificSignature", "isLocalDeclaration", "ir.serialization.common"})
public class DeclarationTable {
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;
    @NotNull
    private final GlobalDeclarationTable globalDeclarationTable;
    @NotNull
    private final IdSignatureSerializer signaturer;

    public DeclarationTable(@NotNull GlobalDeclarationTable globalTable) {
        Intrinsics.checkNotNullParameter((Object)globalTable, (String)"globalTable");
        this.table = new LinkedHashMap();
        this.globalDeclarationTable = globalTable;
        this.signaturer = new IdSignatureSerializer(globalTable.getPublicIdSignatureComputer(), this);
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    @NotNull
    protected GlobalDeclarationTable getGlobalDeclarationTable() {
        return this.globalDeclarationTable;
    }

    @NotNull
    public IdSignatureSerializer getSignaturer() {
        return this.signaturer;
    }

    public final void inFile(@Nullable IrFile file2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        IrFile irFile = file2;
        this.getSignaturer().inFile(irFile != null ? irFile.getSymbol() : null, block);
    }

    private final boolean isLocalDeclaration(IrDeclaration $this$isLocalDeclaration, boolean compatibleMode) {
        return !this.isExportedDeclaration($this$isLocalDeclaration, compatibleMode);
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.getGlobalDeclarationTable().isExportedDeclaration(declaration2, compatibleMode);
    }

    @Nullable
    protected IdSignature tryComputeBackendSpecificSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return null;
    }

    private final IdSignature allocateIndexedSignature(IrDeclaration declaration2, boolean compatibleMode) {
        IdSignature idSignature;
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.getSignaturer().composeFileLocalIdSignature(declaration2, compatibleMode);
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    private final IdSignature computeSignatureByDeclaration(IrDeclaration declaration2, boolean compatibleMode) {
        IdSignature idSignature = this.tryComputeBackendSpecificSignature(declaration2);
        if (idSignature != null) {
            IdSignature it = idSignature;
            boolean bl = false;
            return it;
        }
        return this.isLocalDeclaration(declaration2, compatibleMode) ? this.allocateIndexedSignature(declaration2, compatibleMode) : this.getGlobalDeclarationTable().computeSignatureByDeclaration(declaration2, compatibleMode);
    }

    @NotNull
    public final IdSignature privateDeclarationSignature(@NotNull IrDeclaration declaration2, boolean compatibleMode, @NotNull Function0<? extends IdSignature> builder2) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(builder2, (String)"builder");
        boolean bl = this.isLocalDeclaration(declaration2, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl2 = false;
            IdSignature answer$iv = (IdSignature)builder2.invoke();
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    @NotNull
    public IdSignature signatureByDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.computeSignatureByDeclaration(declaration2, compatibleMode);
    }

    public final void assumeDeclarationSignature(@NotNull IrDeclaration declaration2, @NotNull IdSignature signature2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        boolean bl2 = bl = this.table.get(declaration2) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Declaration table already has signature for " + RenderIrElementKt.render(declaration2);
            throw new AssertionError((Object)string2);
        }
        this.table.put(declaration2, signature2);
    }
}

