/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.inheritance;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.plexus.util.StringUtils;

public class PathDescriptor {
    private final URL baseUrl;
    private final URL pathUrl;
    private final String relativePath;

    public PathDescriptor(String path) throws MalformedURLException {
        this((URL)null, path);
    }

    public PathDescriptor(String base, String path) throws MalformedURLException {
        this(PathDescriptor.buildBaseUrl(base), path);
    }

    public PathDescriptor(URL baseUrl, String path) throws MalformedURLException {
        this.baseUrl = baseUrl;
        URL pathURL = null;
        String relPath = null;
        try {
            pathURL = new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                pathURL = PathDescriptor.buildUrl(baseUrl, path);
            }
            catch (MalformedURLException e2) {
                relPath = path != null && path.startsWith("/") ? path.substring(1) : path;
            }
        }
        this.pathUrl = pathURL;
        this.relativePath = relPath;
    }

    private static URL buildBaseUrl(String base) throws MalformedURLException {
        if (base == null) {
            return null;
        }
        try {
            return new URL(base);
        }
        catch (MalformedURLException e) {
            return new File(base).toURI().toURL();
        }
    }

    private static URL buildUrl(URL baseUrl, String path) throws MalformedURLException {
        if (baseUrl == null) {
            throw new MalformedURLException("Base is null!");
        }
        if (path == null) {
            return baseUrl;
        }
        if (baseUrl.getProtocol().equals("file")) {
            return new File(baseUrl.getFile(), path).toURI().toURL();
        }
        if (path.startsWith("/") && baseUrl.getPath().endsWith("/")) {
            return new URL(baseUrl, path.substring(1));
        }
        return new URL(baseUrl, path);
    }

    public boolean isFile() {
        return this.isRelative() || this.pathUrl.getProtocol().equals("file");
    }

    public boolean isRelative() {
        return this.pathUrl == null;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public URL getPathUrl() {
        return this.pathUrl;
    }

    public String getPath() {
        if (this.getPathUrl() != null) {
            if (this.isFile()) {
                return StringUtils.stripEnd((String)this.getPathUrl().getPath(), (String)"/");
            }
            return this.getPathUrl().getPath();
        }
        return this.relativePath;
    }

    public String getLocation() {
        if (this.isFile()) {
            if (this.getPathUrl() != null) {
                return StringUtils.stripEnd((String)this.getPathUrl().getFile(), (String)"/");
            }
            return this.relativePath;
        }
        return this.getPathUrl().toExternalForm();
    }

    public String toString() {
        StringBuilder res = new StringBuilder(StringUtils.isNotEmpty((String)this.relativePath) ? this.relativePath : String.valueOf(this.pathUrl));
        res.append(" (Base: ").append(this.baseUrl).append(") Location: ").append(this.getLocation());
        return res.toString();
    }
}

