/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsECDSA13Verifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsECDSA13Verifier(BcTlsCrypto bcTlsCrypto, ECPublicKeyParameters eCPublicKeyParameters, int n) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)eCPublicKeyParameters);
        if (!SignatureScheme.isECDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = n;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner eCDSASigner = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator(this.crypto.createDigest(n)));
        DSADigestSigner dSADigestSigner = new DSADigestSigner((DSA)eCDSASigner, (Digest)new NullDigest());
        dSADigestSigner.init(false, (CipherParameters)this.publicKey);
        dSADigestSigner.update(byArray, 0, byArray.length);
        return dSADigestSigner.verifySignature(digitallySigned.getSignature());
    }
}

