/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private static final int BUF_SIZE = 32768;
    private final Cipher cipher;
    private final String algorithm;
    private final boolean isEncrypting;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(Cipher cipher, String string, boolean bl) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = string;
        this.isEncrypting = bl;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) {
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    @Override
    public void init(byte[] byArray, int n, int n2) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = TlsUtils.copyOfRangeExact(byArray, n, n + n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            this.cipher.init(this.isEncrypting ? 1 : 2, (Key)this.key, new IvParameterSpec(this.nextIV), null);
            this.nextIV = null;
            if (!this.isEncrypting) {
                this.nextIV = TlsUtils.copyOfRangeExact(byArray, n + n2 - this.cipher.getBlockSize(), n + n2);
            }
            int n4 = 0;
            while (n2 > 32768) {
                n4 += this.cipher.update(byArray, n, 32768, byArray2, n3 + n4);
                n += 32768;
                n2 -= 32768;
            }
            n4 += this.cipher.update(byArray, n, n2, byArray2, n3 + n4);
            n4 += this.cipher.doFinal(byArray2, n3 + n4);
            if (this.isEncrypting) {
                this.nextIV = TlsUtils.copyOfRangeExact(byArray2, n3 + n4 - this.cipher.getBlockSize(), n3 + n4);
            }
            return n4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

